<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReversalMobilePOS StructType
 * @subpackage Structs
 */
class ReversalMobilePOS extends AbstractStructBase
{
    /**
     * The inIssuerTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inIssuerTranId;
    /**
     * The inMerchantTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inMerchantTranId;
    /**
     * The inIssuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $inIssuerMerchantId;
    /**
     * The inTerminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inTerminalId;
    /**
     * The inCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inCardNumber;
    /**
     * The inAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inAmount;
    /**
     * Constructor method for ReversalMobilePOS
     * @uses ReversalMobilePOS::setInIssuerTranId()
     * @uses ReversalMobilePOS::setInMerchantTranId()
     * @uses ReversalMobilePOS::setInIssuerMerchantId()
     * @uses ReversalMobilePOS::setInTerminalId()
     * @uses ReversalMobilePOS::setInCardNumber()
     * @uses ReversalMobilePOS::setInAmount()
     * @param int $inIssuerTranId
     * @param string $inMerchantTranId
     * @param int $inIssuerMerchantId
     * @param string $inTerminalId
     * @param string $inCardNumber
     * @param int $inAmount
     */
    public function __construct($inIssuerTranId = null, $inMerchantTranId = null, $inIssuerMerchantId = null, $inTerminalId = null, $inCardNumber = null, $inAmount = null)
    {
        $this
            ->setInIssuerTranId($inIssuerTranId)
            ->setInMerchantTranId($inMerchantTranId)
            ->setInIssuerMerchantId($inIssuerMerchantId)
            ->setInTerminalId($inTerminalId)
            ->setInCardNumber($inCardNumber)
            ->setInAmount($inAmount);
    }
    /**
     * Get inIssuerTranId value
     * @return int|null
     */
    public function getInIssuerTranId()
    {
        return $this->inIssuerTranId;
    }
    /**
     * Set inIssuerTranId value
     * @param int $inIssuerTranId
     * @return \StructType\ReversalMobilePOS
     */
    public function setInIssuerTranId($inIssuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($inIssuerTranId) && !(is_int($inIssuerTranId) || ctype_digit($inIssuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inIssuerTranId, true), gettype($inIssuerTranId)), __LINE__);
        }
        $this->inIssuerTranId = $inIssuerTranId;
        return $this;
    }
    /**
     * Get inMerchantTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInMerchantTranId()
    {
        return isset($this->inMerchantTranId) ? $this->inMerchantTranId : null;
    }
    /**
     * Set inMerchantTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inMerchantTranId
     * @return \StructType\ReversalMobilePOS
     */
    public function setInMerchantTranId($inMerchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($inMerchantTranId) && !is_string($inMerchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inMerchantTranId, true), gettype($inMerchantTranId)), __LINE__);
        }
        if (is_null($inMerchantTranId) || (is_array($inMerchantTranId) && empty($inMerchantTranId))) {
            unset($this->inMerchantTranId);
        } else {
            $this->inMerchantTranId = $inMerchantTranId;
        }
        return $this;
    }
    /**
     * Get inIssuerMerchantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInIssuerMerchantId()
    {
        return isset($this->inIssuerMerchantId) ? $this->inIssuerMerchantId : null;
    }
    /**
     * Set inIssuerMerchantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inIssuerMerchantId
     * @return \StructType\ReversalMobilePOS
     */
    public function setInIssuerMerchantId($inIssuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($inIssuerMerchantId) && !(is_int($inIssuerMerchantId) || ctype_digit($inIssuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inIssuerMerchantId, true), gettype($inIssuerMerchantId)), __LINE__);
        }
        if (is_null($inIssuerMerchantId) || (is_array($inIssuerMerchantId) && empty($inIssuerMerchantId))) {
            unset($this->inIssuerMerchantId);
        } else {
            $this->inIssuerMerchantId = $inIssuerMerchantId;
        }
        return $this;
    }
    /**
     * Get inTerminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInTerminalId()
    {
        return isset($this->inTerminalId) ? $this->inTerminalId : null;
    }
    /**
     * Set inTerminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inTerminalId
     * @return \StructType\ReversalMobilePOS
     */
    public function setInTerminalId($inTerminalId = null)
    {
        // validation for constraint: string
        if (!is_null($inTerminalId) && !is_string($inTerminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inTerminalId, true), gettype($inTerminalId)), __LINE__);
        }
        if (is_null($inTerminalId) || (is_array($inTerminalId) && empty($inTerminalId))) {
            unset($this->inTerminalId);
        } else {
            $this->inTerminalId = $inTerminalId;
        }
        return $this;
    }
    /**
     * Get inCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInCardNumber()
    {
        return isset($this->inCardNumber) ? $this->inCardNumber : null;
    }
    /**
     * Set inCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inCardNumber
     * @return \StructType\ReversalMobilePOS
     */
    public function setInCardNumber($inCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($inCardNumber) && !is_string($inCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inCardNumber, true), gettype($inCardNumber)), __LINE__);
        }
        if (is_null($inCardNumber) || (is_array($inCardNumber) && empty($inCardNumber))) {
            unset($this->inCardNumber);
        } else {
            $this->inCardNumber = $inCardNumber;
        }
        return $this;
    }
    /**
     * Get inAmount value
     * @return int|null
     */
    public function getInAmount()
    {
        return $this->inAmount;
    }
    /**
     * Set inAmount value
     * @param int $inAmount
     * @return \StructType\ReversalMobilePOS
     */
    public function setInAmount($inAmount = null)
    {
        // validation for constraint: int
        if (!is_null($inAmount) && !(is_int($inAmount) || ctype_digit($inAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inAmount, true), gettype($inAmount)), __LINE__);
        }
        $this->inAmount = $inAmount;
        return $this;
    }
}
