<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetResponseByIssuerTranId StructType
 * @subpackage Structs
 */
class GetResponseByIssuerTranId extends AbstractStructBase
{
    /**
     * The inIssuerTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inIssuerTranId;
    /**
     * The inMerchantTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inMerchantTranId;
    /**
     * The inAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inAmount;
    /**
     * Constructor method for GetResponseByIssuerTranId
     * @uses GetResponseByIssuerTranId::setInIssuerTranId()
     * @uses GetResponseByIssuerTranId::setInMerchantTranId()
     * @uses GetResponseByIssuerTranId::setInAmount()
     * @param int $inIssuerTranId
     * @param string $inMerchantTranId
     * @param int $inAmount
     */
    public function __construct($inIssuerTranId = null, $inMerchantTranId = null, $inAmount = null)
    {
        $this
            ->setInIssuerTranId($inIssuerTranId)
            ->setInMerchantTranId($inMerchantTranId)
            ->setInAmount($inAmount);
    }
    /**
     * Get inIssuerTranId value
     * @return int|null
     */
    public function getInIssuerTranId()
    {
        return $this->inIssuerTranId;
    }
    /**
     * Set inIssuerTranId value
     * @param int $inIssuerTranId
     * @return \StructType\GetResponseByIssuerTranId
     */
    public function setInIssuerTranId($inIssuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($inIssuerTranId) && !(is_int($inIssuerTranId) || ctype_digit($inIssuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inIssuerTranId, true), gettype($inIssuerTranId)), __LINE__);
        }
        $this->inIssuerTranId = $inIssuerTranId;
        return $this;
    }
    /**
     * Get inMerchantTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInMerchantTranId()
    {
        return isset($this->inMerchantTranId) ? $this->inMerchantTranId : null;
    }
    /**
     * Set inMerchantTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inMerchantTranId
     * @return \StructType\GetResponseByIssuerTranId
     */
    public function setInMerchantTranId($inMerchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($inMerchantTranId) && !is_string($inMerchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inMerchantTranId, true), gettype($inMerchantTranId)), __LINE__);
        }
        if (is_null($inMerchantTranId) || (is_array($inMerchantTranId) && empty($inMerchantTranId))) {
            unset($this->inMerchantTranId);
        } else {
            $this->inMerchantTranId = $inMerchantTranId;
        }
        return $this;
    }
    /**
     * Get inAmount value
     * @return int|null
     */
    public function getInAmount()
    {
        return $this->inAmount;
    }
    /**
     * Set inAmount value
     * @param int $inAmount
     * @return \StructType\GetResponseByIssuerTranId
     */
    public function setInAmount($inAmount = null)
    {
        // validation for constraint: int
        if (!is_null($inAmount) && !(is_int($inAmount) || ctype_digit($inAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inAmount, true), gettype($inAmount)), __LINE__);
        }
        $this->inAmount = $inAmount;
        return $this;
    }
}
