<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reversal ServiceType
 * @subpackage Services
 */
class Reversal extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReversalByMerchantTranId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReversalByMerchantTranId $parameters
     * @return \StructType\ReversalByMerchantTranIdResponse|bool
     */
    public function ReversalByMerchantTranId(\StructType\ReversalByMerchantTranId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReversalByMerchantTranId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReversalByIssuerTranId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReversalByIssuerTranId $parameters
     * @return \StructType\ReversalByIssuerTranIdResponse|bool
     */
    public function ReversalByIssuerTranId(\StructType\ReversalByIssuerTranId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReversalByIssuerTranId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReversalByIssuerTranIdResponse|\StructType\ReversalByMerchantTranIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
