<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReversalByIssuerTranId StructType
 * @subpackage Structs
 */
class ReversalByIssuerTranId extends AbstractStructBase
{
    /**
     * The inIssuerTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inIssuerTranId;
    /**
     * The inMerchantTranid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inMerchantTranid;
    /**
     * The inAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inAmount;
    /**
     * Constructor method for ReversalByIssuerTranId
     * @uses ReversalByIssuerTranId::setInIssuerTranId()
     * @uses ReversalByIssuerTranId::setInMerchantTranid()
     * @uses ReversalByIssuerTranId::setInAmount()
     * @param int $inIssuerTranId
     * @param string $inMerchantTranid
     * @param int $inAmount
     */
    public function __construct($inIssuerTranId = null, $inMerchantTranid = null, $inAmount = null)
    {
        $this
            ->setInIssuerTranId($inIssuerTranId)
            ->setInMerchantTranid($inMerchantTranid)
            ->setInAmount($inAmount);
    }
    /**
     * Get inIssuerTranId value
     * @return int|null
     */
    public function getInIssuerTranId()
    {
        return $this->inIssuerTranId;
    }
    /**
     * Set inIssuerTranId value
     * @param int $inIssuerTranId
     * @return \StructType\ReversalByIssuerTranId
     */
    public function setInIssuerTranId($inIssuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($inIssuerTranId) && !(is_int($inIssuerTranId) || ctype_digit($inIssuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inIssuerTranId, true), gettype($inIssuerTranId)), __LINE__);
        }
        $this->inIssuerTranId = $inIssuerTranId;
        return $this;
    }
    /**
     * Get inMerchantTranid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInMerchantTranid()
    {
        return isset($this->inMerchantTranid) ? $this->inMerchantTranid : null;
    }
    /**
     * Set inMerchantTranid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inMerchantTranid
     * @return \StructType\ReversalByIssuerTranId
     */
    public function setInMerchantTranid($inMerchantTranid = null)
    {
        // validation for constraint: string
        if (!is_null($inMerchantTranid) && !is_string($inMerchantTranid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inMerchantTranid, true), gettype($inMerchantTranid)), __LINE__);
        }
        if (is_null($inMerchantTranid) || (is_array($inMerchantTranid) && empty($inMerchantTranid))) {
            unset($this->inMerchantTranid);
        } else {
            $this->inMerchantTranid = $inMerchantTranid;
        }
        return $this;
    }
    /**
     * Get inAmount value
     * @return int|null
     */
    public function getInAmount()
    {
        return $this->inAmount;
    }
    /**
     * Set inAmount value
     * @param int $inAmount
     * @return \StructType\ReversalByIssuerTranId
     */
    public function setInAmount($inAmount = null)
    {
        // validation for constraint: int
        if (!is_null($inAmount) && !(is_int($inAmount) || ctype_digit($inAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inAmount, true), gettype($inAmount)), __LINE__);
        }
        $this->inAmount = $inAmount;
        return $this;
    }
}
