<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Purchase ServiceType
 * @subpackage Services
 */
class Purchase extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PurchaseCardPresent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PurchaseCardPresent $parameters
     * @return \StructType\PurchaseCardPresentResponse|bool
     */
    public function PurchaseCardPresent(\StructType\PurchaseCardPresent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PurchaseCardPresent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PurchaseCardNotPresent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PurchaseCardNotPresent $parameters
     * @return \StructType\PurchaseCardNotPresentResponse|bool
     */
    public function PurchaseCardNotPresent(\StructType\PurchaseCardNotPresent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PurchaseCardNotPresent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PurchaseCardNotPresentResponse|\StructType\PurchaseCardPresentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
