<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReversalByMerchantTranId StructType
 * @subpackage Structs
 */
class ReversalByMerchantTranId extends AbstractStructBase
{
    /**
     * The MerchantUniqueTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantUniqueTranId;
    /**
     * The IssuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssuerMerchantId;
    /**
     * The TerminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalId;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Amount;
    /**
     * Constructor method for ReversalByMerchantTranId
     * @uses ReversalByMerchantTranId::setMerchantUniqueTranId()
     * @uses ReversalByMerchantTranId::setIssuerMerchantId()
     * @uses ReversalByMerchantTranId::setTerminalId()
     * @uses ReversalByMerchantTranId::setAmount()
     * @param string $merchantUniqueTranId
     * @param int $issuerMerchantId
     * @param string $terminalId
     * @param int $amount
     */
    public function __construct($merchantUniqueTranId = null, $issuerMerchantId = null, $terminalId = null, $amount = null)
    {
        $this
            ->setMerchantUniqueTranId($merchantUniqueTranId)
            ->setIssuerMerchantId($issuerMerchantId)
            ->setTerminalId($terminalId)
            ->setAmount($amount);
    }
    /**
     * Get MerchantUniqueTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantUniqueTranId()
    {
        return isset($this->MerchantUniqueTranId) ? $this->MerchantUniqueTranId : null;
    }
    /**
     * Set MerchantUniqueTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantUniqueTranId
     * @return \StructType\ReversalByMerchantTranId
     */
    public function setMerchantUniqueTranId($merchantUniqueTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantUniqueTranId) && !is_string($merchantUniqueTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantUniqueTranId, true), gettype($merchantUniqueTranId)), __LINE__);
        }
        if (is_null($merchantUniqueTranId) || (is_array($merchantUniqueTranId) && empty($merchantUniqueTranId))) {
            unset($this->MerchantUniqueTranId);
        } else {
            $this->MerchantUniqueTranId = $merchantUniqueTranId;
        }
        return $this;
    }
    /**
     * Get IssuerMerchantId value
     * @return int|null
     */
    public function getIssuerMerchantId()
    {
        return $this->IssuerMerchantId;
    }
    /**
     * Set IssuerMerchantId value
     * @param int $issuerMerchantId
     * @return \StructType\ReversalByMerchantTranId
     */
    public function setIssuerMerchantId($issuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerMerchantId) && !(is_int($issuerMerchantId) || ctype_digit($issuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerMerchantId, true), gettype($issuerMerchantId)), __LINE__);
        }
        $this->IssuerMerchantId = $issuerMerchantId;
        return $this;
    }
    /**
     * Get TerminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalId()
    {
        return isset($this->TerminalId) ? $this->TerminalId : null;
    }
    /**
     * Set TerminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalId
     * @return \StructType\ReversalByMerchantTranId
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        if (is_null($terminalId) || (is_array($terminalId) && empty($terminalId))) {
            unset($this->TerminalId);
        } else {
            $this->TerminalId = $terminalId;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\ReversalByMerchantTranId
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
