<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReversalByIssuerTranIdResponse StructType
 * @subpackage Structs
 */
class ReversalByIssuerTranIdResponse extends AbstractStructBase
{
    /**
     * The IssuerReversalUniqueTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssuerReversalUniqueTranId;
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The TranDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TranDateTime;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseCode;
    /**
     * The ResponseMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseMessage;
    /**
     * Constructor method for ReversalByIssuerTranIdResponse
     * @uses ReversalByIssuerTranIdResponse::setIssuerReversalUniqueTranId()
     * @uses ReversalByIssuerTranIdResponse::setAuthorizationCode()
     * @uses ReversalByIssuerTranIdResponse::setTranDateTime()
     * @uses ReversalByIssuerTranIdResponse::setResponseCode()
     * @uses ReversalByIssuerTranIdResponse::setResponseMessage()
     * @param int $issuerReversalUniqueTranId
     * @param string $authorizationCode
     * @param string $tranDateTime
     * @param string $responseCode
     * @param string $responseMessage
     */
    public function __construct($issuerReversalUniqueTranId = null, $authorizationCode = null, $tranDateTime = null, $responseCode = null, $responseMessage = null)
    {
        $this
            ->setIssuerReversalUniqueTranId($issuerReversalUniqueTranId)
            ->setAuthorizationCode($authorizationCode)
            ->setTranDateTime($tranDateTime)
            ->setResponseCode($responseCode)
            ->setResponseMessage($responseMessage);
    }
    /**
     * Get IssuerReversalUniqueTranId value
     * @return int|null
     */
    public function getIssuerReversalUniqueTranId()
    {
        return $this->IssuerReversalUniqueTranId;
    }
    /**
     * Set IssuerReversalUniqueTranId value
     * @param int $issuerReversalUniqueTranId
     * @return \StructType\ReversalByIssuerTranIdResponse
     */
    public function setIssuerReversalUniqueTranId($issuerReversalUniqueTranId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerReversalUniqueTranId) && !(is_int($issuerReversalUniqueTranId) || ctype_digit($issuerReversalUniqueTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerReversalUniqueTranId, true), gettype($issuerReversalUniqueTranId)), __LINE__);
        }
        $this->IssuerReversalUniqueTranId = $issuerReversalUniqueTranId;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return isset($this->AuthorizationCode) ? $this->AuthorizationCode : null;
    }
    /**
     * Set AuthorizationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationCode
     * @return \StructType\ReversalByIssuerTranIdResponse
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        if (is_null($authorizationCode) || (is_array($authorizationCode) && empty($authorizationCode))) {
            unset($this->AuthorizationCode);
        } else {
            $this->AuthorizationCode = $authorizationCode;
        }
        return $this;
    }
    /**
     * Get TranDateTime value
     * @return string|null
     */
    public function getTranDateTime()
    {
        return $this->TranDateTime;
    }
    /**
     * Set TranDateTime value
     * @param string $tranDateTime
     * @return \StructType\ReversalByIssuerTranIdResponse
     */
    public function setTranDateTime($tranDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($tranDateTime) && !is_string($tranDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDateTime, true), gettype($tranDateTime)), __LINE__);
        }
        $this->TranDateTime = $tranDateTime;
        return $this;
    }
    /**
     * Get ResponseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCode()
    {
        return isset($this->ResponseCode) ? $this->ResponseCode : null;
    }
    /**
     * Set ResponseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCode
     * @return \StructType\ReversalByIssuerTranIdResponse
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        if (is_null($responseCode) || (is_array($responseCode) && empty($responseCode))) {
            unset($this->ResponseCode);
        } else {
            $this->ResponseCode = $responseCode;
        }
        return $this;
    }
    /**
     * Get ResponseMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseMessage()
    {
        return isset($this->ResponseMessage) ? $this->ResponseMessage : null;
    }
    /**
     * Set ResponseMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseMessage
     * @return \StructType\ReversalByIssuerTranIdResponse
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        if (is_null($responseMessage) || (is_array($responseMessage) && empty($responseMessage))) {
            unset($this->ResponseMessage);
        } else {
            $this->ResponseMessage = $responseMessage;
        }
        return $this;
    }
}
