<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseCardPresent StructType
 * @subpackage Structs
 */
class PurchaseCardPresent extends AbstractStructBase
{
    /**
     * The MerchantUniqueTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantUniqueTranId;
    /**
     * The IssuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssuerMerchantId;
    /**
     * The TerminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalId;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CVV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CVV1;
    /**
     * The CafeteriaCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CafeteriaCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Amount;
    /**
     * Constructor method for PurchaseCardPresent
     * @uses PurchaseCardPresent::setMerchantUniqueTranId()
     * @uses PurchaseCardPresent::setIssuerMerchantId()
     * @uses PurchaseCardPresent::setTerminalId()
     * @uses PurchaseCardPresent::setCardNumber()
     * @uses PurchaseCardPresent::setCVV1()
     * @uses PurchaseCardPresent::setCafeteriaCode()
     * @uses PurchaseCardPresent::setAmount()
     * @param string $merchantUniqueTranId
     * @param int $issuerMerchantId
     * @param string $terminalId
     * @param string $cardNumber
     * @param string $cVV1
     * @param string $cafeteriaCode
     * @param int $amount
     */
    public function __construct($merchantUniqueTranId = null, $issuerMerchantId = null, $terminalId = null, $cardNumber = null, $cVV1 = null, $cafeteriaCode = null, $amount = null)
    {
        $this
            ->setMerchantUniqueTranId($merchantUniqueTranId)
            ->setIssuerMerchantId($issuerMerchantId)
            ->setTerminalId($terminalId)
            ->setCardNumber($cardNumber)
            ->setCVV1($cVV1)
            ->setCafeteriaCode($cafeteriaCode)
            ->setAmount($amount);
    }
    /**
     * Get MerchantUniqueTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantUniqueTranId()
    {
        return isset($this->MerchantUniqueTranId) ? $this->MerchantUniqueTranId : null;
    }
    /**
     * Set MerchantUniqueTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantUniqueTranId
     * @return \StructType\PurchaseCardPresent
     */
    public function setMerchantUniqueTranId($merchantUniqueTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantUniqueTranId) && !is_string($merchantUniqueTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantUniqueTranId, true), gettype($merchantUniqueTranId)), __LINE__);
        }
        if (is_null($merchantUniqueTranId) || (is_array($merchantUniqueTranId) && empty($merchantUniqueTranId))) {
            unset($this->MerchantUniqueTranId);
        } else {
            $this->MerchantUniqueTranId = $merchantUniqueTranId;
        }
        return $this;
    }
    /**
     * Get IssuerMerchantId value
     * @return int|null
     */
    public function getIssuerMerchantId()
    {
        return $this->IssuerMerchantId;
    }
    /**
     * Set IssuerMerchantId value
     * @param int $issuerMerchantId
     * @return \StructType\PurchaseCardPresent
     */
    public function setIssuerMerchantId($issuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerMerchantId) && !(is_int($issuerMerchantId) || ctype_digit($issuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerMerchantId, true), gettype($issuerMerchantId)), __LINE__);
        }
        $this->IssuerMerchantId = $issuerMerchantId;
        return $this;
    }
    /**
     * Get TerminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalId()
    {
        return isset($this->TerminalId) ? $this->TerminalId : null;
    }
    /**
     * Set TerminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalId
     * @return \StructType\PurchaseCardPresent
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        if (is_null($terminalId) || (is_array($terminalId) && empty($terminalId))) {
            unset($this->TerminalId);
        } else {
            $this->TerminalId = $terminalId;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \StructType\PurchaseCardPresent
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CVV1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCVV1()
    {
        return isset($this->CVV1) ? $this->CVV1 : null;
    }
    /**
     * Set CVV1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cVV1
     * @return \StructType\PurchaseCardPresent
     */
    public function setCVV1($cVV1 = null)
    {
        // validation for constraint: string
        if (!is_null($cVV1) && !is_string($cVV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVV1, true), gettype($cVV1)), __LINE__);
        }
        if (is_null($cVV1) || (is_array($cVV1) && empty($cVV1))) {
            unset($this->CVV1);
        } else {
            $this->CVV1 = $cVV1;
        }
        return $this;
    }
    /**
     * Get CafeteriaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCafeteriaCode()
    {
        return isset($this->CafeteriaCode) ? $this->CafeteriaCode : null;
    }
    /**
     * Set CafeteriaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cafeteriaCode
     * @return \StructType\PurchaseCardPresent
     */
    public function setCafeteriaCode($cafeteriaCode = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteriaCode) && !is_string($cafeteriaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cafeteriaCode, true), gettype($cafeteriaCode)), __LINE__);
        }
        if (is_null($cafeteriaCode) || (is_array($cafeteriaCode) && empty($cafeteriaCode))) {
            unset($this->CafeteriaCode);
        } else {
            $this->CafeteriaCode = $cafeteriaCode;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\PurchaseCardPresent
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
