<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetResponseByIssuerTranId StructType
 * @subpackage Structs
 */
class GetResponseByIssuerTranId extends AbstractStructBase
{
    /**
     * The IssuerUniqueTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssuerUniqueTranId;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Amount;
    /**
     * Constructor method for GetResponseByIssuerTranId
     * @uses GetResponseByIssuerTranId::setIssuerUniqueTranId()
     * @uses GetResponseByIssuerTranId::setAmount()
     * @param int $issuerUniqueTranId
     * @param int $amount
     */
    public function __construct($issuerUniqueTranId = null, $amount = null)
    {
        $this
            ->setIssuerUniqueTranId($issuerUniqueTranId)
            ->setAmount($amount);
    }
    /**
     * Get IssuerUniqueTranId value
     * @return int|null
     */
    public function getIssuerUniqueTranId()
    {
        return $this->IssuerUniqueTranId;
    }
    /**
     * Set IssuerUniqueTranId value
     * @param int $issuerUniqueTranId
     * @return \StructType\GetResponseByIssuerTranId
     */
    public function setIssuerUniqueTranId($issuerUniqueTranId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerUniqueTranId) && !(is_int($issuerUniqueTranId) || ctype_digit($issuerUniqueTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerUniqueTranId, true), gettype($issuerUniqueTranId)), __LINE__);
        }
        $this->IssuerUniqueTranId = $issuerUniqueTranId;
        return $this;
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\GetResponseByIssuerTranId
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
