<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \TravelAccess\ClassMap::get(),
);
/**
 * Samples for Search ServiceType
 */
$search = new \TravelAccess\ServiceType\Search($options);
/**
 * Sample call for Search operation/method
 */
if ($search->Search(new \TravelAccess\StructType\Search()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \TravelAccess\ServiceType\Get($options);
/**
 * Sample call for GetDetail operation/method
 */
if ($get->GetDetail(new \TravelAccess\StructType\GetDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Book ServiceType
 */
$book = new \TravelAccess\ServiceType\Book($options);
/**
 * Sample call for Book operation/method
 */
if ($book->Book(new \TravelAccess\StructType\Book()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Samples for Reserve ServiceType
 */
$reserve = new \TravelAccess\ServiceType\Reserve($options);
/**
 * Sample call for Reserve operation/method
 */
if ($reserve->Reserve(new \TravelAccess\StructType\Reserve()) !== false) {
    print_r($reserve->getResult());
} else {
    print_r($reserve->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \TravelAccess\ServiceType\Retrieve($options);
/**
 * Sample call for RetrieveRecord operation/method
 */
if ($retrieve->RetrieveRecord(new \TravelAccess\StructType\RetrieveRecord()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \TravelAccess\ServiceType\Cancel($options);
/**
 * Sample call for CancelRecord operation/method
 */
if ($cancel->CancelRecord(new \TravelAccess\StructType\CancelRecord()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \TravelAccess\ServiceType\Update($options);
/**
 * Sample call for UpdateRecord operation/method
 */
if ($update->UpdateRecord(new \TravelAccess\StructType\UpdateRecord()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
