<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneNumber StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PhoneNumber
 * @subpackage Structs
 */
class PhoneNumber extends AbstractStructBase
{
    /**
     * The AreaCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AreaCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CountryCode;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for PhoneNumber
     * @uses PhoneNumber::setAreaCode()
     * @uses PhoneNumber::setCountryCode()
     * @uses PhoneNumber::setNumber()
     * @uses PhoneNumber::setType()
     * @param int $areaCode
     * @param int $countryCode
     * @param string $number
     * @param string $type
     */
    public function __construct($areaCode = null, $countryCode = null, $number = null, $type = null)
    {
        $this
            ->setAreaCode($areaCode)
            ->setCountryCode($countryCode)
            ->setNumber($number)
            ->setType($type);
    }
    /**
     * Get AreaCode value
     * @return int|null
     */
    public function getAreaCode()
    {
        return $this->AreaCode;
    }
    /**
     * Set AreaCode value
     * @param int $areaCode
     * @return \TravelAccess\StructType\PhoneNumber
     */
    public function setAreaCode($areaCode = null)
    {
        // validation for constraint: int
        if (!is_null($areaCode) && !is_numeric($areaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($areaCode)), __LINE__);
        }
        $this->AreaCode = $areaCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return int|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param int $countryCode
     * @return \TravelAccess\StructType\PhoneNumber
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: int
        if (!is_null($countryCode) && !is_numeric($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \TravelAccess\StructType\PhoneNumber
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \TravelAccess\EnumType\PhoneNumberType::valueIsValid()
     * @uses \TravelAccess\EnumType\PhoneNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \TravelAccess\StructType\PhoneNumber
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\TravelAccess\EnumType\PhoneNumberType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \TravelAccess\EnumType\PhoneNumberType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\PhoneNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
