<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerProduct StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerProduct
 * @subpackage Structs
 */
class PassengerProduct extends AbstractStructBase
{
    /**
     * The ExtendData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ExtendData;
    /**
     * The Key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The PassengerKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassengerKey;
    /**
     * Constructor method for PassengerProduct
     * @uses PassengerProduct::setExtendData()
     * @uses PassengerProduct::setKey()
     * @uses PassengerProduct::setPassengerKey()
     * @param \TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring $extendData
     * @param string $key
     * @param string $passengerKey
     */
    public function __construct(\TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring $extendData = null, $key = null, $passengerKey = null)
    {
        $this
            ->setExtendData($extendData)
            ->setKey($key)
            ->setPassengerKey($passengerKey);
    }
    /**
     * Get ExtendData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getExtendData()
    {
        return isset($this->ExtendData) ? $this->ExtendData : null;
    }
    /**
     * Set ExtendData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring $extendData
     * @return \TravelAccess\StructType\PassengerProduct
     */
    public function setExtendData(\TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring $extendData = null)
    {
        if (is_null($extendData) || (is_array($extendData) && empty($extendData))) {
            unset($this->ExtendData);
        } else {
            $this->ExtendData = $extendData;
        }
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \TravelAccess\StructType\PassengerProduct
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get PassengerKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassengerKey()
    {
        return isset($this->PassengerKey) ? $this->PassengerKey : null;
    }
    /**
     * Set PassengerKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passengerKey
     * @return \TravelAccess\StructType\PassengerProduct
     */
    public function setPassengerKey($passengerKey = null)
    {
        // validation for constraint: string
        if (!is_null($passengerKey) && !is_string($passengerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerKey)), __LINE__);
        }
        if (is_null($passengerKey) || (is_array($passengerKey) && empty($passengerKey))) {
            unset($this->PassengerKey);
        } else {
            $this->PassengerKey = $passengerKey;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\PassengerProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
