<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSearchLeg StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q13:FlightSearchLeg
 * @subpackage Structs
 */
class FlightSearchLeg extends SearchLeg
{
    /**
     * The CabinClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinClass;
    /**
     * The DepartureTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureTime;
    /**
     * The MaxConnections
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxConnections;
    /**
     * The PermittedAirlines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfAirline
     */
    public $PermittedAirlines;
    /**
     * The PermittedConnectionPoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfLocation
     */
    public $PermittedConnectionPoints;
    /**
     * The ProhibitedAirlines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfAirline
     */
    public $ProhibitedAirlines;
    /**
     * The ProhibitedConnectionPoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfLocation
     */
    public $ProhibitedConnectionPoints;
    /**
     * Constructor method for FlightSearchLeg
     * @uses FlightSearchLeg::setCabinClass()
     * @uses FlightSearchLeg::setDepartureTime()
     * @uses FlightSearchLeg::setMaxConnections()
     * @uses FlightSearchLeg::setPermittedAirlines()
     * @uses FlightSearchLeg::setPermittedConnectionPoints()
     * @uses FlightSearchLeg::setProhibitedAirlines()
     * @uses FlightSearchLeg::setProhibitedConnectionPoints()
     * @param string $cabinClass
     * @param string $departureTime
     * @param int $maxConnections
     * @param \TravelAccess\ArrayType\ArrayOfAirline $permittedAirlines
     * @param \TravelAccess\ArrayType\ArrayOfLocation $permittedConnectionPoints
     * @param \TravelAccess\ArrayType\ArrayOfAirline $prohibitedAirlines
     * @param \TravelAccess\ArrayType\ArrayOfLocation $prohibitedConnectionPoints
     */
    public function __construct($cabinClass = null, $departureTime = null, $maxConnections = null, \TravelAccess\ArrayType\ArrayOfAirline $permittedAirlines = null, \TravelAccess\ArrayType\ArrayOfLocation $permittedConnectionPoints = null, \TravelAccess\ArrayType\ArrayOfAirline $prohibitedAirlines = null, \TravelAccess\ArrayType\ArrayOfLocation $prohibitedConnectionPoints = null)
    {
        $this
            ->setCabinClass($cabinClass)
            ->setDepartureTime($departureTime)
            ->setMaxConnections($maxConnections)
            ->setPermittedAirlines($permittedAirlines)
            ->setPermittedConnectionPoints($permittedConnectionPoints)
            ->setProhibitedAirlines($prohibitedAirlines)
            ->setProhibitedConnectionPoints($prohibitedConnectionPoints);
    }
    /**
     * Get CabinClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinClass()
    {
        return isset($this->CabinClass) ? $this->CabinClass : null;
    }
    /**
     * Set CabinClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \TravelAccess\EnumType\CabinClass::valueIsValid()
     * @uses \TravelAccess\EnumType\CabinClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinClass
     * @return \TravelAccess\StructType\FlightSearchLeg
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: enumeration
        if (!\TravelAccess\EnumType\CabinClass::valueIsValid($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cabinClass, implode(', ', \TravelAccess\EnumType\CabinClass::getValidValues())), __LINE__);
        }
        if (is_null($cabinClass) || (is_array($cabinClass) && empty($cabinClass))) {
            unset($this->CabinClass);
        } else {
            $this->CabinClass = $cabinClass;
        }
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \TravelAccess\StructType\FlightSearchLeg
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get MaxConnections value
     * @return int|null
     */
    public function getMaxConnections()
    {
        return $this->MaxConnections;
    }
    /**
     * Set MaxConnections value
     * @param int $maxConnections
     * @return \TravelAccess\StructType\FlightSearchLeg
     */
    public function setMaxConnections($maxConnections = null)
    {
        // validation for constraint: int
        if (!is_null($maxConnections) && !is_numeric($maxConnections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxConnections)), __LINE__);
        }
        $this->MaxConnections = $maxConnections;
        return $this;
    }
    /**
     * Get PermittedAirlines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfAirline|null
     */
    public function getPermittedAirlines()
    {
        return isset($this->PermittedAirlines) ? $this->PermittedAirlines : null;
    }
    /**
     * Set PermittedAirlines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfAirline $permittedAirlines
     * @return \TravelAccess\StructType\FlightSearchLeg
     */
    public function setPermittedAirlines(\TravelAccess\ArrayType\ArrayOfAirline $permittedAirlines = null)
    {
        if (is_null($permittedAirlines) || (is_array($permittedAirlines) && empty($permittedAirlines))) {
            unset($this->PermittedAirlines);
        } else {
            $this->PermittedAirlines = $permittedAirlines;
        }
        return $this;
    }
    /**
     * Get PermittedConnectionPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfLocation|null
     */
    public function getPermittedConnectionPoints()
    {
        return isset($this->PermittedConnectionPoints) ? $this->PermittedConnectionPoints : null;
    }
    /**
     * Set PermittedConnectionPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfLocation $permittedConnectionPoints
     * @return \TravelAccess\StructType\FlightSearchLeg
     */
    public function setPermittedConnectionPoints(\TravelAccess\ArrayType\ArrayOfLocation $permittedConnectionPoints = null)
    {
        if (is_null($permittedConnectionPoints) || (is_array($permittedConnectionPoints) && empty($permittedConnectionPoints))) {
            unset($this->PermittedConnectionPoints);
        } else {
            $this->PermittedConnectionPoints = $permittedConnectionPoints;
        }
        return $this;
    }
    /**
     * Get ProhibitedAirlines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfAirline|null
     */
    public function getProhibitedAirlines()
    {
        return isset($this->ProhibitedAirlines) ? $this->ProhibitedAirlines : null;
    }
    /**
     * Set ProhibitedAirlines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfAirline $prohibitedAirlines
     * @return \TravelAccess\StructType\FlightSearchLeg
     */
    public function setProhibitedAirlines(\TravelAccess\ArrayType\ArrayOfAirline $prohibitedAirlines = null)
    {
        if (is_null($prohibitedAirlines) || (is_array($prohibitedAirlines) && empty($prohibitedAirlines))) {
            unset($this->ProhibitedAirlines);
        } else {
            $this->ProhibitedAirlines = $prohibitedAirlines;
        }
        return $this;
    }
    /**
     * Get ProhibitedConnectionPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfLocation|null
     */
    public function getProhibitedConnectionPoints()
    {
        return isset($this->ProhibitedConnectionPoints) ? $this->ProhibitedConnectionPoints : null;
    }
    /**
     * Set ProhibitedConnectionPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfLocation $prohibitedConnectionPoints
     * @return \TravelAccess\StructType\FlightSearchLeg
     */
    public function setProhibitedConnectionPoints(\TravelAccess\ArrayType\ArrayOfLocation $prohibitedConnectionPoints = null)
    {
        if (is_null($prohibitedConnectionPoints) || (is_array($prohibitedConnectionPoints) && empty($prohibitedConnectionPoints))) {
            unset($this->ProhibitedConnectionPoints);
        } else {
            $this->ProhibitedConnectionPoints = $prohibitedConnectionPoints;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\FlightSearchLeg
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
