<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fault StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Fault
 * @subpackage Structs
 */
class Fault extends AbstractStructBase
{
    /**
     * The InnerFaults
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfFault
     */
    public $InnerFaults;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Properties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $Properties;
    /**
     * The StackTrace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StackTrace;
    /**
     * Constructor method for Fault
     * @uses Fault::setInnerFaults()
     * @uses Fault::setMessage()
     * @uses Fault::setName()
     * @uses Fault::setProperties()
     * @uses Fault::setStackTrace()
     * @param \TravelAccess\ArrayType\ArrayOfFault $innerFaults
     * @param string $message
     * @param string $name
     * @param \TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring $properties
     * @param string $stackTrace
     */
    public function __construct(\TravelAccess\ArrayType\ArrayOfFault $innerFaults = null, $message = null, $name = null, \TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring $properties = null, $stackTrace = null)
    {
        $this
            ->setInnerFaults($innerFaults)
            ->setMessage($message)
            ->setName($name)
            ->setProperties($properties)
            ->setStackTrace($stackTrace);
    }
    /**
     * Get InnerFaults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfFault|null
     */
    public function getInnerFaults()
    {
        return isset($this->InnerFaults) ? $this->InnerFaults : null;
    }
    /**
     * Set InnerFaults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfFault $innerFaults
     * @return \TravelAccess\StructType\Fault
     */
    public function setInnerFaults(\TravelAccess\ArrayType\ArrayOfFault $innerFaults = null)
    {
        if (is_null($innerFaults) || (is_array($innerFaults) && empty($innerFaults))) {
            unset($this->InnerFaults);
        } else {
            $this->InnerFaults = $innerFaults;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \TravelAccess\StructType\Fault
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \TravelAccess\StructType\Fault
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Properties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getProperties()
    {
        return isset($this->Properties) ? $this->Properties : null;
    }
    /**
     * Set Properties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring $properties
     * @return \TravelAccess\StructType\Fault
     */
    public function setProperties(\TravelAccess\ArrayType\ArrayOfKeyValueOfstringstring $properties = null)
    {
        if (is_null($properties) || (is_array($properties) && empty($properties))) {
            unset($this->Properties);
        } else {
            $this->Properties = $properties;
        }
        return $this;
    }
    /**
     * Get StackTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStackTrace()
    {
        return isset($this->StackTrace) ? $this->StackTrace : null;
    }
    /**
     * Set StackTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stackTrace
     * @return \TravelAccess\StructType\Fault
     */
    public function setStackTrace($stackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($stackTrace) && !is_string($stackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stackTrace)), __LINE__);
        }
        if (is_null($stackTrace) || (is_array($stackTrace) && empty($stackTrace))) {
            unset($this->StackTrace);
        } else {
            $this->StackTrace = $stackTrace;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\Fault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
