<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelRecordRequestOfPricingCombination StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CancelRecordRequestOfPricingCombination
 * @subpackage Structs
 */
class CancelRecordRequestOfPricingCombination extends BaseRequest
{
    /**
     * The BookingKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingKey;
    /**
     * The ReservationKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationKey;
    /**
     * Constructor method for CancelRecordRequestOfPricingCombination
     * @uses CancelRecordRequestOfPricingCombination::setBookingKey()
     * @uses CancelRecordRequestOfPricingCombination::setReservationKey()
     * @param string $bookingKey
     * @param string $reservationKey
     */
    public function __construct($bookingKey = null, $reservationKey = null)
    {
        $this
            ->setBookingKey($bookingKey)
            ->setReservationKey($reservationKey);
    }
    /**
     * Get BookingKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingKey()
    {
        return isset($this->BookingKey) ? $this->BookingKey : null;
    }
    /**
     * Set BookingKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingKey
     * @return \TravelAccess\StructType\CancelRecordRequestOfPricingCombination
     */
    public function setBookingKey($bookingKey = null)
    {
        // validation for constraint: string
        if (!is_null($bookingKey) && !is_string($bookingKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingKey)), __LINE__);
        }
        if (is_null($bookingKey) || (is_array($bookingKey) && empty($bookingKey))) {
            unset($this->BookingKey);
        } else {
            $this->BookingKey = $bookingKey;
        }
        return $this;
    }
    /**
     * Get ReservationKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationKey()
    {
        return isset($this->ReservationKey) ? $this->ReservationKey : null;
    }
    /**
     * Set ReservationKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationKey
     * @return \TravelAccess\StructType\CancelRecordRequestOfPricingCombination
     */
    public function setReservationKey($reservationKey = null)
    {
        // validation for constraint: string
        if (!is_null($reservationKey) && !is_string($reservationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationKey)), __LINE__);
        }
        if (is_null($reservationKey) || (is_array($reservationKey) && empty($reservationKey))) {
            unset($this->ReservationKey);
        } else {
            $this->ReservationKey = $reservationKey;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\CancelRecordRequestOfPricingCombination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
