<?php

namespace TravelAccess\EnumType;

/**
 * This class stands for ReturnDiagnosticsFlags EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReturnDiagnosticsFlags
 * @subpackage Enumerations
 */
class ReturnDiagnosticsFlags
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'ProviderInfo'
     * @return string 'ProviderInfo'
     */
    const VALUE_PROVIDER_INFO = 'ProviderInfo';
    /**
     * Constant for value 'ServiceRequest'
     * @return string 'ServiceRequest'
     */
    const VALUE_SERVICE_REQUEST = 'ServiceRequest';
    /**
     * Constant for value 'ServiceResponse'
     * @return string 'ServiceResponse'
     */
    const VALUE_SERVICE_RESPONSE = 'ServiceResponse';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_PROVIDER_INFO
     * @uses self::VALUE_SERVICE_REQUEST
     * @uses self::VALUE_SERVICE_RESPONSE
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_PROVIDER_INFO,
            self::VALUE_SERVICE_REQUEST,
            self::VALUE_SERVICE_RESPONSE,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
