<?php

namespace TravelAccess\EnumType;

/**
 * This class stands for PassengerType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerType
 * @subpackage Enumerations
 */
class PassengerType
{
    /**
     * Constant for value 'Infant'
     * @return string 'Infant'
     */
    const VALUE_INFANT = 'Infant';
    /**
     * Constant for value 'Adult'
     * @return string 'Adult'
     */
    const VALUE_ADULT = 'Adult';
    /**
     * Constant for value 'Overaged'
     * @return string 'Overaged'
     */
    const VALUE_OVERAGED = 'Overaged';
    /**
     * Constant for value 'Student'
     * @return string 'Student'
     */
    const VALUE_STUDENT = 'Student';
    /**
     * Constant for value 'Child'
     * @return string 'Child'
     */
    const VALUE_CHILD = 'Child';
    /**
     * Constant for value 'Military'
     * @return string 'Military'
     */
    const VALUE_MILITARY = 'Military';
    /**
     * Constant for value 'Teacher'
     * @return string 'Teacher'
     */
    const VALUE_TEACHER = 'Teacher';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INFANT
     * @uses self::VALUE_ADULT
     * @uses self::VALUE_OVERAGED
     * @uses self::VALUE_STUDENT
     * @uses self::VALUE_CHILD
     * @uses self::VALUE_MILITARY
     * @uses self::VALUE_TEACHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INFANT,
            self::VALUE_ADULT,
            self::VALUE_OVERAGED,
            self::VALUE_STUDENT,
            self::VALUE_CHILD,
            self::VALUE_MILITARY,
            self::VALUE_TEACHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
