<?php

namespace TravelAccess\EnumType;

/**
 * This class stands for PackageSearchType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PackageSearchType
 * @subpackage Enumerations
 */
class PackageSearchType
{
    /**
     * Constant for value 'NonPackage'
     * @return string 'NonPackage'
     */
    const VALUE_NON_PACKAGE = 'NonPackage';
    /**
     * Constant for value 'FlightHotel'
     * @return string 'FlightHotel'
     */
    const VALUE_FLIGHT_HOTEL = 'FlightHotel';
    /**
     * Constant for value 'HotelCar'
     * @return string 'HotelCar'
     */
    const VALUE_HOTEL_CAR = 'HotelCar';
    /**
     * Constant for value 'FlightHotelCar'
     * @return string 'FlightHotelCar'
     */
    const VALUE_FLIGHT_HOTEL_CAR = 'FlightHotelCar';
    /**
     * Constant for value 'FlightCar'
     * @return string 'FlightCar'
     */
    const VALUE_FLIGHT_CAR = 'FlightCar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NON_PACKAGE
     * @uses self::VALUE_FLIGHT_HOTEL
     * @uses self::VALUE_HOTEL_CAR
     * @uses self::VALUE_FLIGHT_HOTEL_CAR
     * @uses self::VALUE_FLIGHT_CAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NON_PACKAGE,
            self::VALUE_FLIGHT_HOTEL,
            self::VALUE_HOTEL_CAR,
            self::VALUE_FLIGHT_HOTEL_CAR,
            self::VALUE_FLIGHT_CAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
