<?php

namespace TravelAccess;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Search' => '\\TravelAccess\\StructType\\Search',
            'FlightSearchRequest' => '\\TravelAccess\\StructType\\FlightSearchRequest',
            'ArrayOfFlightSearchLeg' => '\\TravelAccess\\ArrayType\\ArrayOfFlightSearchLeg',
            'FlightSearchLeg' => '\\TravelAccess\\StructType\\FlightSearchLeg',
            'ArrayOfAirline' => '\\TravelAccess\\ArrayType\\ArrayOfAirline',
            'Airline' => '\\TravelAccess\\StructType\\Airline',
            'SearchResponse' => '\\TravelAccess\\StructType\\SearchResponse',
            'FlightSearchResponse' => '\\TravelAccess\\StructType\\FlightSearchResponse',
            'ArrayOfPricingCombination' => '\\TravelAccess\\ArrayType\\ArrayOfPricingCombination',
            'PricingCombination' => '\\TravelAccess\\StructType\\PricingCombination',
            'ArrayOfCombinationGroup' => '\\TravelAccess\\ArrayType\\ArrayOfCombinationGroup',
            'CombinationGroup' => '\\TravelAccess\\StructType\\CombinationGroup',
            'ArrayOfFlightSegment' => '\\TravelAccess\\ArrayType\\ArrayOfFlightSegment',
            'FlightSegment' => '\\TravelAccess\\StructType\\FlightSegment',
            'ArrayOfBaggageDetail' => '\\TravelAccess\\ArrayType\\ArrayOfBaggageDetail',
            'BaggageDetail' => '\\TravelAccess\\StructType\\BaggageDetail',
            'CombinationGroups' => '\\TravelAccess\\StructType\\CombinationGroups',
            'CombinationGroupItem' => '\\TravelAccess\\StructType\\CombinationGroupItem',
            'FlightSegments' => '\\TravelAccess\\StructType\\FlightSegments',
            'FlightSegmentItem' => '\\TravelAccess\\StructType\\FlightSegmentItem',
            'GetDetail' => '\\TravelAccess\\StructType\\GetDetail',
            'FlightDetailRequest' => '\\TravelAccess\\StructType\\FlightDetailRequest',
            'GetDetailResponse' => '\\TravelAccess\\StructType\\GetDetailResponse',
            'FlightDetailResponse' => '\\TravelAccess\\StructType\\FlightDetailResponse',
            'Book' => '\\TravelAccess\\StructType\\Book',
            'FlightBookingRequest' => '\\TravelAccess\\StructType\\FlightBookingRequest',
            'BookResponse' => '\\TravelAccess\\StructType\\BookResponse',
            'FlightBookingResponse' => '\\TravelAccess\\StructType\\FlightBookingResponse',
            'FlightPassengerProduct' => '\\TravelAccess\\StructType\\FlightPassengerProduct',
            'ArrayOfFlightSegmentCoupon' => '\\TravelAccess\\ArrayType\\ArrayOfFlightSegmentCoupon',
            'FlightSegmentCoupon' => '\\TravelAccess\\StructType\\FlightSegmentCoupon',
            'Reserve' => '\\TravelAccess\\StructType\\Reserve',
            'FlightReservationRequest' => '\\TravelAccess\\StructType\\FlightReservationRequest',
            'ReserveResponse' => '\\TravelAccess\\StructType\\ReserveResponse',
            'FlightReservationResponse' => '\\TravelAccess\\StructType\\FlightReservationResponse',
            'RetrieveRecord' => '\\TravelAccess\\StructType\\RetrieveRecord',
            'FlightRetrieveRecordRequest' => '\\TravelAccess\\StructType\\FlightRetrieveRecordRequest',
            'RetrieveRecordResponse' => '\\TravelAccess\\StructType\\RetrieveRecordResponse',
            'FlightRetrieveRecordResponse' => '\\TravelAccess\\StructType\\FlightRetrieveRecordResponse',
            'CancelRecord' => '\\TravelAccess\\StructType\\CancelRecord',
            'FlightCancelRecordRequest' => '\\TravelAccess\\StructType\\FlightCancelRecordRequest',
            'CancelRecordResponse' => '\\TravelAccess\\StructType\\CancelRecordResponse',
            'FlightCancelRecordResponse' => '\\TravelAccess\\StructType\\FlightCancelRecordResponse',
            'UpdateRecord' => '\\TravelAccess\\StructType\\UpdateRecord',
            'FlightUpdateRecordRequest' => '\\TravelAccess\\StructType\\FlightUpdateRecordRequest',
            'UpdateRecordResponse' => '\\TravelAccess\\StructType\\UpdateRecordResponse',
            'FlightUpdateRecordResponse' => '\\TravelAccess\\StructType\\FlightUpdateRecordResponse',
            'SearchRequest' => '\\TravelAccess\\StructType\\SearchRequest',
            'BaseRequest' => '\\TravelAccess\\StructType\\BaseRequest',
            'SearchLeg' => '\\TravelAccess\\StructType\\SearchLeg',
            'Location' => '\\TravelAccess\\StructType\\Location',
            'Region' => '\\TravelAccess\\StructType\\Region',
            'Airport' => '\\TravelAccess\\StructType\\Airport',
            'City' => '\\TravelAccess\\StructType\\City',
            'Country' => '\\TravelAccess\\StructType\\Country',
            'Continent' => '\\TravelAccess\\StructType\\Continent',
            'District' => '\\TravelAccess\\StructType\\District',
            'State' => '\\TravelAccess\\StructType\\State',
            'Station' => '\\TravelAccess\\StructType\\Station',
            'Zone' => '\\TravelAccess\\StructType\\Zone',
            'Coordinate' => '\\TravelAccess\\StructType\\Coordinate',
            'ArrayOfLocation' => '\\TravelAccess\\ArrayType\\ArrayOfLocation',
            'ArrayOfSearchPassenger' => '\\TravelAccess\\ArrayType\\ArrayOfSearchPassenger',
            'SearchPassenger' => '\\TravelAccess\\StructType\\SearchPassenger',
            'BookingPassenger' => '\\TravelAccess\\StructType\\BookingPassenger',
            'Address' => '\\TravelAccess\\StructType\\Address',
            'ArrayOfPhoneNumber' => '\\TravelAccess\\ArrayType\\ArrayOfPhoneNumber',
            'PhoneNumber' => '\\TravelAccess\\StructType\\PhoneNumber',
            'ArrayOfSpecialServiceRequest' => '\\TravelAccess\\ArrayType\\ArrayOfSpecialServiceRequest',
            'SpecialServiceRequest' => '\\TravelAccess\\StructType\\SpecialServiceRequest',
            'WellChairRequest' => '\\TravelAccess\\StructType\\WellChairRequest',
            'MealRequest' => '\\TravelAccess\\StructType\\MealRequest',
            'PassportInformation' => '\\TravelAccess\\StructType\\PassportInformation',
            'SearchResponseOfPricingCombination' => '\\TravelAccess\\StructType\\SearchResponseOfPricingCombination',
            'BaseResponse' => '\\TravelAccess\\StructType\\BaseResponse',
            'ResponseDiagnostics' => '\\TravelAccess\\StructType\\ResponseDiagnostics',
            'Fault' => '\\TravelAccess\\StructType\\Fault',
            'ArrayOfFault' => '\\TravelAccess\\ArrayType\\ArrayOfFault',
            'ProviderInfo' => '\\TravelAccess\\StructType\\ProviderInfo',
            'ArrayOfResponseDiagnostics' => '\\TravelAccess\\ArrayType\\ArrayOfResponseDiagnostics',
            'TravelProduct' => '\\TravelAccess\\StructType\\TravelProduct',
            'Price' => '\\TravelAccess\\StructType\\Price',
            'Fee' => '\\TravelAccess\\StructType\\Fee',
            'ArrayOfPassengerPrice' => '\\TravelAccess\\ArrayType\\ArrayOfPassengerPrice',
            'PassengerPrice' => '\\TravelAccess\\StructType\\PassengerPrice',
            'ServiceFault' => '\\TravelAccess\\StructType\\ServiceFault',
            'DetailRequest' => '\\TravelAccess\\StructType\\DetailRequest',
            'DetailResponseOfPricingCombination' => '\\TravelAccess\\StructType\\DetailResponseOfPricingCombination',
            'ValidationInformations' => '\\TravelAccess\\StructType\\ValidationInformations',
            'AgeValidationInformation' => '\\TravelAccess\\StructType\\AgeValidationInformation',
            'BookingRequest' => '\\TravelAccess\\StructType\\BookingRequest',
            'ArrayOfBookingPassenger' => '\\TravelAccess\\ArrayType\\ArrayOfBookingPassenger',
            'BookingResponseOfPricingCombination' => '\\TravelAccess\\StructType\\BookingResponseOfPricingCombination',
            'BookingRecordOfPricingCombination' => '\\TravelAccess\\StructType\\BookingRecordOfPricingCombination',
            'ArrayOfPassengerProduct' => '\\TravelAccess\\ArrayType\\ArrayOfPassengerProduct',
            'PassengerProduct' => '\\TravelAccess\\StructType\\PassengerProduct',
            'ReservationRequest' => '\\TravelAccess\\StructType\\ReservationRequest',
            'ReservationResponseOfPricingCombination' => '\\TravelAccess\\StructType\\ReservationResponseOfPricingCombination',
            'ReservationRecordOfPricingCombination' => '\\TravelAccess\\StructType\\ReservationRecordOfPricingCombination',
            'RetrieveRecordRequestOfPricingCombinationEMpHts2s' => '\\TravelAccess\\StructType\\RetrieveRecordRequestOfPricingCombinationEMpHts2s',
            'RetrieveRecordResponseOfPricingCombination' => '\\TravelAccess\\StructType\\RetrieveRecordResponseOfPricingCombination',
            'CancelRecordRequestOfPricingCombination' => '\\TravelAccess\\StructType\\CancelRecordRequestOfPricingCombination',
            'CancelRecordResponseOfPricingCombination' => '\\TravelAccess\\StructType\\CancelRecordResponseOfPricingCombination',
            'UpdateRecordRequest' => '\\TravelAccess\\StructType\\UpdateRecordRequest',
            'UpdateRecordResponseOfPricingCombination' => '\\TravelAccess\\StructType\\UpdateRecordResponseOfPricingCombination',
            'ArrayOfKeyValueOfstringstring' => '\\TravelAccess\\ArrayType\\ArrayOfKeyValueOfstringstring',
            'KeyValueOfstringstring' => '\\TravelAccess\\StructType\\KeyValueOfstringstring',
            'ArrayOfstring' => '\\TravelAccess\\ArrayType\\ArrayOfstring',
        );
    }
}
