<?php

namespace TravelAccess\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSearchPassenger ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSearchPassenger
 * @subpackage Arrays
 */
class ArrayOfSearchPassenger extends AbstractStructArrayBase
{
    /**
     * The SearchPassenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\SearchPassenger[]
     */
    public $SearchPassenger;
    /**
     * Constructor method for ArrayOfSearchPassenger
     * @uses ArrayOfSearchPassenger::setSearchPassenger()
     * @param \TravelAccess\StructType\SearchPassenger[] $searchPassenger
     */
    public function __construct(array $searchPassenger = array())
    {
        $this
            ->setSearchPassenger($searchPassenger);
    }
    /**
     * Get SearchPassenger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\SearchPassenger[]|null
     */
    public function getSearchPassenger()
    {
        return isset($this->SearchPassenger) ? $this->SearchPassenger : null;
    }
    /**
     * Set SearchPassenger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\SearchPassenger[] $searchPassenger
     * @return \TravelAccess\ArrayType\ArrayOfSearchPassenger
     */
    public function setSearchPassenger(array $searchPassenger = array())
    {
        foreach ($searchPassenger as $arrayOfSearchPassengerSearchPassengerItem) {
            // validation for constraint: itemType
            if (!$arrayOfSearchPassengerSearchPassengerItem instanceof \TravelAccess\StructType\SearchPassenger) {
                throw new \InvalidArgumentException(sprintf('The SearchPassenger property can only contain items of \TravelAccess\StructType\SearchPassenger, "%s" given', is_object($arrayOfSearchPassengerSearchPassengerItem) ? get_class($arrayOfSearchPassengerSearchPassengerItem) : gettype($arrayOfSearchPassengerSearchPassengerItem)), __LINE__);
            }
        }
        if (is_null($searchPassenger) || (is_array($searchPassenger) && empty($searchPassenger))) {
            unset($this->SearchPassenger);
        } else {
            $this->SearchPassenger = $searchPassenger;
        }
        return $this;
    }
    /**
     * Add item to SearchPassenger value
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\SearchPassenger $item
     * @return \TravelAccess\ArrayType\ArrayOfSearchPassenger
     */
    public function addToSearchPassenger(\TravelAccess\StructType\SearchPassenger $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TravelAccess\StructType\SearchPassenger) {
            throw new \InvalidArgumentException(sprintf('The SearchPassenger property can only contain items of \TravelAccess\StructType\SearchPassenger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SearchPassenger[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TravelAccess\StructType\SearchPassenger|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TravelAccess\StructType\SearchPassenger|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TravelAccess\StructType\SearchPassenger|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TravelAccess\StructType\SearchPassenger|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TravelAccess\StructType\SearchPassenger|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SearchPassenger
     */
    public function getAttributeName()
    {
        return 'SearchPassenger';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\ArrayType\ArrayOfSearchPassenger
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
