<?php

namespace TravelAccess\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPhoneNumber ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPhoneNumber
 * @subpackage Arrays
 */
class ArrayOfPhoneNumber extends AbstractStructArrayBase
{
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\PhoneNumber[]
     */
    public $PhoneNumber;
    /**
     * Constructor method for ArrayOfPhoneNumber
     * @uses ArrayOfPhoneNumber::setPhoneNumber()
     * @param \TravelAccess\StructType\PhoneNumber[] $phoneNumber
     */
    public function __construct(array $phoneNumber = array())
    {
        $this
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\PhoneNumber[]|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\PhoneNumber[] $phoneNumber
     * @return \TravelAccess\ArrayType\ArrayOfPhoneNumber
     */
    public function setPhoneNumber(array $phoneNumber = array())
    {
        foreach ($phoneNumber as $arrayOfPhoneNumberPhoneNumberItem) {
            // validation for constraint: itemType
            if (!$arrayOfPhoneNumberPhoneNumberItem instanceof \TravelAccess\StructType\PhoneNumber) {
                throw new \InvalidArgumentException(sprintf('The PhoneNumber property can only contain items of \TravelAccess\StructType\PhoneNumber, "%s" given', is_object($arrayOfPhoneNumberPhoneNumberItem) ? get_class($arrayOfPhoneNumberPhoneNumberItem) : gettype($arrayOfPhoneNumberPhoneNumberItem)), __LINE__);
            }
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Add item to PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\PhoneNumber $item
     * @return \TravelAccess\ArrayType\ArrayOfPhoneNumber
     */
    public function addToPhoneNumber(\TravelAccess\StructType\PhoneNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TravelAccess\StructType\PhoneNumber) {
            throw new \InvalidArgumentException(sprintf('The PhoneNumber property can only contain items of \TravelAccess\StructType\PhoneNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhoneNumber[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TravelAccess\StructType\PhoneNumber|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TravelAccess\StructType\PhoneNumber|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TravelAccess\StructType\PhoneNumber|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TravelAccess\StructType\PhoneNumber|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TravelAccess\StructType\PhoneNumber|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PhoneNumber
     */
    public function getAttributeName()
    {
        return 'PhoneNumber';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\ArrayType\ArrayOfPhoneNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
