<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelProduct StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TravelProduct
 * @subpackage Structs
 */
class TravelProduct extends AbstractStructBase
{
    /**
     * The BasePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \TravelAccess\StructType\Price
     */
    public $BasePrice;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \TravelAccess\StructType\Price
     */
    public $Discount;
    /**
     * The Fee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \TravelAccess\StructType\Fee
     */
    public $Fee;
    /**
     * The Key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The PassengerPrices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfPassengerPrice
     */
    public $PassengerPrices;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \TravelAccess\StructType\Price
     */
    public $Taxes;
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \TravelAccess\StructType\Price
     */
    public $TotalPrice;
    /**
     * Constructor method for TravelProduct
     * @uses TravelProduct::setBasePrice()
     * @uses TravelProduct::setDiscount()
     * @uses TravelProduct::setFee()
     * @uses TravelProduct::setKey()
     * @uses TravelProduct::setPassengerPrices()
     * @uses TravelProduct::setTaxes()
     * @uses TravelProduct::setTotalPrice()
     * @param \TravelAccess\StructType\Price $basePrice
     * @param \TravelAccess\StructType\Price $discount
     * @param \TravelAccess\StructType\Fee $fee
     * @param string $key
     * @param \TravelAccess\ArrayType\ArrayOfPassengerPrice $passengerPrices
     * @param \TravelAccess\StructType\Price $taxes
     * @param \TravelAccess\StructType\Price $totalPrice
     */
    public function __construct(\TravelAccess\StructType\Price $basePrice = null, \TravelAccess\StructType\Price $discount = null, \TravelAccess\StructType\Fee $fee = null, $key = null, \TravelAccess\ArrayType\ArrayOfPassengerPrice $passengerPrices = null, \TravelAccess\StructType\Price $taxes = null, \TravelAccess\StructType\Price $totalPrice = null)
    {
        $this
            ->setBasePrice($basePrice)
            ->setDiscount($discount)
            ->setFee($fee)
            ->setKey($key)
            ->setPassengerPrices($passengerPrices)
            ->setTaxes($taxes)
            ->setTotalPrice($totalPrice);
    }
    /**
     * Get BasePrice value
     * @return \TravelAccess\StructType\Price|null
     */
    public function getBasePrice()
    {
        return $this->BasePrice;
    }
    /**
     * Set BasePrice value
     * @param \TravelAccess\StructType\Price $basePrice
     * @return \TravelAccess\StructType\TravelProduct
     */
    public function setBasePrice(\TravelAccess\StructType\Price $basePrice = null)
    {
        $this->BasePrice = $basePrice;
        return $this;
    }
    /**
     * Get Discount value
     * @return \TravelAccess\StructType\Price|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \TravelAccess\StructType\Price $discount
     * @return \TravelAccess\StructType\TravelProduct
     */
    public function setDiscount(\TravelAccess\StructType\Price $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Fee value
     * @return \TravelAccess\StructType\Fee|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @param \TravelAccess\StructType\Fee $fee
     * @return \TravelAccess\StructType\TravelProduct
     */
    public function setFee(\TravelAccess\StructType\Fee $fee = null)
    {
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \TravelAccess\StructType\TravelProduct
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get PassengerPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfPassengerPrice|null
     */
    public function getPassengerPrices()
    {
        return isset($this->PassengerPrices) ? $this->PassengerPrices : null;
    }
    /**
     * Set PassengerPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfPassengerPrice $passengerPrices
     * @return \TravelAccess\StructType\TravelProduct
     */
    public function setPassengerPrices(\TravelAccess\ArrayType\ArrayOfPassengerPrice $passengerPrices = null)
    {
        if (is_null($passengerPrices) || (is_array($passengerPrices) && empty($passengerPrices))) {
            unset($this->PassengerPrices);
        } else {
            $this->PassengerPrices = $passengerPrices;
        }
        return $this;
    }
    /**
     * Get Taxes value
     * @return \TravelAccess\StructType\Price|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \TravelAccess\StructType\Price $taxes
     * @return \TravelAccess\StructType\TravelProduct
     */
    public function setTaxes(\TravelAccess\StructType\Price $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \TravelAccess\StructType\Price|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \TravelAccess\StructType\Price $totalPrice
     * @return \TravelAccess\StructType\TravelProduct
     */
    public function setTotalPrice(\TravelAccess\StructType\Price $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\TravelProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
