<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassportInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PassportInformation
 * @subpackage Structs
 */
class PassportInformation extends SpecialServiceRequest
{
    /**
     * The IssuanceDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IssuanceDate;
    /**
     * The IssuingCountry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Country
     */
    public $IssuingCountry;
    /**
     * The PassportNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassportNumber;
    /**
     * Constructor method for PassportInformation
     * @uses PassportInformation::setIssuanceDate()
     * @uses PassportInformation::setIssuingCountry()
     * @uses PassportInformation::setPassportNumber()
     * @param string $issuanceDate
     * @param \TravelAccess\StructType\Country $issuingCountry
     * @param string $passportNumber
     */
    public function __construct($issuanceDate = null, \TravelAccess\StructType\Country $issuingCountry = null, $passportNumber = null)
    {
        $this
            ->setIssuanceDate($issuanceDate)
            ->setIssuingCountry($issuingCountry)
            ->setPassportNumber($passportNumber);
    }
    /**
     * Get IssuanceDate value
     * @return string|null
     */
    public function getIssuanceDate()
    {
        return $this->IssuanceDate;
    }
    /**
     * Set IssuanceDate value
     * @param string $issuanceDate
     * @return \TravelAccess\StructType\PassportInformation
     */
    public function setIssuanceDate($issuanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($issuanceDate) && !is_string($issuanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuanceDate)), __LINE__);
        }
        $this->IssuanceDate = $issuanceDate;
        return $this;
    }
    /**
     * Get IssuingCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Country|null
     */
    public function getIssuingCountry()
    {
        return isset($this->IssuingCountry) ? $this->IssuingCountry : null;
    }
    /**
     * Set IssuingCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\Country $issuingCountry
     * @return \TravelAccess\StructType\PassportInformation
     */
    public function setIssuingCountry(\TravelAccess\StructType\Country $issuingCountry = null)
    {
        if (is_null($issuingCountry) || (is_array($issuingCountry) && empty($issuingCountry))) {
            unset($this->IssuingCountry);
        } else {
            $this->IssuingCountry = $issuingCountry;
        }
        return $this;
    }
    /**
     * Get PassportNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassportNumber()
    {
        return isset($this->PassportNumber) ? $this->PassportNumber : null;
    }
    /**
     * Set PassportNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passportNumber
     * @return \TravelAccess\StructType\PassportInformation
     */
    public function setPassportNumber($passportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($passportNumber) && !is_string($passportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passportNumber)), __LINE__);
        }
        if (is_null($passportNumber) || (is_array($passportNumber) && empty($passportNumber))) {
            unset($this->PassportNumber);
        } else {
            $this->PassportNumber = $passportNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\PassportInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
