<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q44:FlightSegment
 * @subpackage Structs
 */
class FlightSegment extends AbstractStructBase
{
    /**
     * The ArrivalTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalTime;
    /**
     * The BaggageDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfBaggageDetail
     */
    public $BaggageDetails;
    /**
     * The BookingCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingCode;
    /**
     * The CabinClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CabinClass;
    /**
     * The DepartureTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureTime;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Airport
     */
    public $Destination;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The FlightTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $FlightTime;
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GroupId;
    /**
     * The IsPromo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPromo;
    /**
     * The IsReservable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsReservable;
    /**
     * The Key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Airline
     */
    public $MarketingAirline;
    /**
     * The OperatingAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Airline
     */
    public $OperatingAirline;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Airport
     */
    public $Origin;
    /**
     * The Quota
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quota;
    /**
     * The Rules
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfstring
     */
    public $Rules;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setArrivalTime()
     * @uses FlightSegment::setBaggageDetails()
     * @uses FlightSegment::setBookingCode()
     * @uses FlightSegment::setCabinClass()
     * @uses FlightSegment::setDepartureTime()
     * @uses FlightSegment::setDestination()
     * @uses FlightSegment::setFlightNumber()
     * @uses FlightSegment::setFlightTime()
     * @uses FlightSegment::setGroupId()
     * @uses FlightSegment::setIsPromo()
     * @uses FlightSegment::setIsReservable()
     * @uses FlightSegment::setKey()
     * @uses FlightSegment::setMarketingAirline()
     * @uses FlightSegment::setOperatingAirline()
     * @uses FlightSegment::setOrigin()
     * @uses FlightSegment::setQuota()
     * @uses FlightSegment::setRules()
     * @param string $arrivalTime
     * @param \TravelAccess\ArrayType\ArrayOfBaggageDetail $baggageDetails
     * @param string $bookingCode
     * @param string $cabinClass
     * @param string $departureTime
     * @param \TravelAccess\StructType\Airport $destination
     * @param string $flightNumber
     * @param string $flightTime
     * @param int $groupId
     * @param bool $isPromo
     * @param bool $isReservable
     * @param string $key
     * @param \TravelAccess\StructType\Airline $marketingAirline
     * @param \TravelAccess\StructType\Airline $operatingAirline
     * @param \TravelAccess\StructType\Airport $origin
     * @param int $quota
     * @param \TravelAccess\ArrayType\ArrayOfstring $rules
     */
    public function __construct($arrivalTime = null, \TravelAccess\ArrayType\ArrayOfBaggageDetail $baggageDetails = null, $bookingCode = null, $cabinClass = null, $departureTime = null, \TravelAccess\StructType\Airport $destination = null, $flightNumber = null, $flightTime = null, $groupId = null, $isPromo = null, $isReservable = null, $key = null, \TravelAccess\StructType\Airline $marketingAirline = null, \TravelAccess\StructType\Airline $operatingAirline = null, \TravelAccess\StructType\Airport $origin = null, $quota = null, \TravelAccess\ArrayType\ArrayOfstring $rules = null)
    {
        $this
            ->setArrivalTime($arrivalTime)
            ->setBaggageDetails($baggageDetails)
            ->setBookingCode($bookingCode)
            ->setCabinClass($cabinClass)
            ->setDepartureTime($departureTime)
            ->setDestination($destination)
            ->setFlightNumber($flightNumber)
            ->setFlightTime($flightTime)
            ->setGroupId($groupId)
            ->setIsPromo($isPromo)
            ->setIsReservable($isReservable)
            ->setKey($key)
            ->setMarketingAirline($marketingAirline)
            ->setOperatingAirline($operatingAirline)
            ->setOrigin($origin)
            ->setQuota($quota)
            ->setRules($rules);
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get BaggageDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfBaggageDetail|null
     */
    public function getBaggageDetails()
    {
        return isset($this->BaggageDetails) ? $this->BaggageDetails : null;
    }
    /**
     * Set BaggageDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfBaggageDetail $baggageDetails
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setBaggageDetails(\TravelAccess\ArrayType\ArrayOfBaggageDetail $baggageDetails = null)
    {
        if (is_null($baggageDetails) || (is_array($baggageDetails) && empty($baggageDetails))) {
            unset($this->BaggageDetails);
        } else {
            $this->BaggageDetails = $baggageDetails;
        }
        return $this;
    }
    /**
     * Get BookingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingCode()
    {
        return isset($this->BookingCode) ? $this->BookingCode : null;
    }
    /**
     * Set BookingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingCode
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingCode)), __LINE__);
        }
        if (is_null($bookingCode) || (is_array($bookingCode) && empty($bookingCode))) {
            unset($this->BookingCode);
        } else {
            $this->BookingCode = $bookingCode;
        }
        return $this;
    }
    /**
     * Get CabinClass value
     * @return string|null
     */
    public function getCabinClass()
    {
        return $this->CabinClass;
    }
    /**
     * Set CabinClass value
     * @uses \TravelAccess\EnumType\CabinClass::valueIsValid()
     * @uses \TravelAccess\EnumType\CabinClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinClass
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: enumeration
        if (!\TravelAccess\EnumType\CabinClass::valueIsValid($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cabinClass, implode(', ', \TravelAccess\EnumType\CabinClass::getValidValues())), __LINE__);
        }
        $this->CabinClass = $cabinClass;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Airport|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\Airport $destination
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setDestination(\TravelAccess\StructType\Airport $destination = null)
    {
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get FlightTime value
     * @return string|null
     */
    public function getFlightTime()
    {
        return $this->FlightTime;
    }
    /**
     * Set FlightTime value
     * @param string $flightTime
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setFlightTime($flightTime = null)
    {
        // validation for constraint: maxInclusive
        if ($flightTime > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $flightTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($flightTime < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $flightTime), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($flightTime) && !preg_match('/\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?/', $flightTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($flightTime, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flightTime) && !is_string($flightTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightTime)), __LINE__);
        }
        $this->FlightTime = $flightTime;
        return $this;
    }
    /**
     * Get GroupId value
     * @return int|null
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !is_numeric($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get IsPromo value
     * @return bool|null
     */
    public function getIsPromo()
    {
        return $this->IsPromo;
    }
    /**
     * Set IsPromo value
     * @param bool $isPromo
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setIsPromo($isPromo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPromo) && !is_bool($isPromo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPromo)), __LINE__);
        }
        $this->IsPromo = $isPromo;
        return $this;
    }
    /**
     * Get IsReservable value
     * @return bool|null
     */
    public function getIsReservable()
    {
        return $this->IsReservable;
    }
    /**
     * Set IsReservable value
     * @param bool $isReservable
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setIsReservable($isReservable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReservable) && !is_bool($isReservable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isReservable)), __LINE__);
        }
        $this->IsReservable = $isReservable;
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get MarketingAirline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Airline|null
     */
    public function getMarketingAirline()
    {
        return isset($this->MarketingAirline) ? $this->MarketingAirline : null;
    }
    /**
     * Set MarketingAirline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\Airline $marketingAirline
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setMarketingAirline(\TravelAccess\StructType\Airline $marketingAirline = null)
    {
        if (is_null($marketingAirline) || (is_array($marketingAirline) && empty($marketingAirline))) {
            unset($this->MarketingAirline);
        } else {
            $this->MarketingAirline = $marketingAirline;
        }
        return $this;
    }
    /**
     * Get OperatingAirline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Airline|null
     */
    public function getOperatingAirline()
    {
        return isset($this->OperatingAirline) ? $this->OperatingAirline : null;
    }
    /**
     * Set OperatingAirline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\Airline $operatingAirline
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setOperatingAirline(\TravelAccess\StructType\Airline $operatingAirline = null)
    {
        if (is_null($operatingAirline) || (is_array($operatingAirline) && empty($operatingAirline))) {
            unset($this->OperatingAirline);
        } else {
            $this->OperatingAirline = $operatingAirline;
        }
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Airport|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\Airport $origin
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setOrigin(\TravelAccess\StructType\Airport $origin = null)
    {
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get Quota value
     * @return int|null
     */
    public function getQuota()
    {
        return $this->Quota;
    }
    /**
     * Set Quota value
     * @param int $quota
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setQuota($quota = null)
    {
        // validation for constraint: int
        if (!is_null($quota) && !is_numeric($quota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quota)), __LINE__);
        }
        $this->Quota = $quota;
        return $this;
    }
    /**
     * Get Rules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfstring|null
     */
    public function getRules()
    {
        return isset($this->Rules) ? $this->Rules : null;
    }
    /**
     * Set Rules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfstring $rules
     * @return \TravelAccess\StructType\FlightSegment
     */
    public function setRules(\TravelAccess\ArrayType\ArrayOfstring $rules = null)
    {
        if (is_null($rules) || (is_array($rules) && empty($rules))) {
            unset($this->Rules);
        } else {
            $this->Rules = $rules;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
