<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BookingRequest
 * @subpackage Structs
 */
class BookingRequest extends BaseRequest
{
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfBookingPassenger
     */
    public $Passengers;
    /**
     * The ProductKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductKey;
    /**
     * Constructor method for BookingRequest
     * @uses BookingRequest::setPassengers()
     * @uses BookingRequest::setProductKey()
     * @param \TravelAccess\ArrayType\ArrayOfBookingPassenger $passengers
     * @param string $productKey
     */
    public function __construct(\TravelAccess\ArrayType\ArrayOfBookingPassenger $passengers = null, $productKey = null)
    {
        $this
            ->setPassengers($passengers)
            ->setProductKey($productKey);
    }
    /**
     * Get Passengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfBookingPassenger|null
     */
    public function getPassengers()
    {
        return isset($this->Passengers) ? $this->Passengers : null;
    }
    /**
     * Set Passengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfBookingPassenger $passengers
     * @return \TravelAccess\StructType\BookingRequest
     */
    public function setPassengers(\TravelAccess\ArrayType\ArrayOfBookingPassenger $passengers = null)
    {
        if (is_null($passengers) || (is_array($passengers) && empty($passengers))) {
            unset($this->Passengers);
        } else {
            $this->Passengers = $passengers;
        }
        return $this;
    }
    /**
     * Get ProductKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductKey()
    {
        return isset($this->ProductKey) ? $this->ProductKey : null;
    }
    /**
     * Set ProductKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productKey
     * @return \TravelAccess\StructType\BookingRequest
     */
    public function setProductKey($productKey = null)
    {
        // validation for constraint: string
        if (!is_null($productKey) && !is_string($productKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productKey)), __LINE__);
        }
        if (is_null($productKey) || (is_array($productKey) && empty($productKey))) {
            unset($this->ProductKey);
        } else {
            $this->ProductKey = $productKey;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\BookingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
