<?php

namespace TravelAccess\EnumType;

/**
 * This class stands for FlightSearchOrderBy EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q6:FlightSearchOrderBy
 * @subpackage Enumerations
 */
class FlightSearchOrderBy
{
    /**
     * Constant for value 'PriceAscending'
     * @return string 'PriceAscending'
     */
    const VALUE_PRICE_ASCENDING = 'PriceAscending';
    /**
     * Constant for value 'PriceDescending'
     * @return string 'PriceDescending'
     */
    const VALUE_PRICE_DESCENDING = 'PriceDescending';
    /**
     * Constant for value 'DepartureTimeAscending'
     * @return string 'DepartureTimeAscending'
     */
    const VALUE_DEPARTURE_TIME_ASCENDING = 'DepartureTimeAscending';
    /**
     * Constant for value 'DepartureTimeDescending'
     * @return string 'DepartureTimeDescending'
     */
    const VALUE_DEPARTURE_TIME_DESCENDING = 'DepartureTimeDescending';
    /**
     * Constant for value 'ArrivalTimeAscending'
     * @return string 'ArrivalTimeAscending'
     */
    const VALUE_ARRIVAL_TIME_ASCENDING = 'ArrivalTimeAscending';
    /**
     * Constant for value 'ArrivalTimeDescending'
     * @return string 'ArrivalTimeDescending'
     */
    const VALUE_ARRIVAL_TIME_DESCENDING = 'ArrivalTimeDescending';
    /**
     * Constant for value 'JourneyTimeAscending'
     * @return string 'JourneyTimeAscending'
     */
    const VALUE_JOURNEY_TIME_ASCENDING = 'JourneyTimeAscending';
    /**
     * Constant for value 'JourneyTimeDescending'
     * @return string 'JourneyTimeDescending'
     */
    const VALUE_JOURNEY_TIME_DESCENDING = 'JourneyTimeDescending';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRICE_ASCENDING
     * @uses self::VALUE_PRICE_DESCENDING
     * @uses self::VALUE_DEPARTURE_TIME_ASCENDING
     * @uses self::VALUE_DEPARTURE_TIME_DESCENDING
     * @uses self::VALUE_ARRIVAL_TIME_ASCENDING
     * @uses self::VALUE_ARRIVAL_TIME_DESCENDING
     * @uses self::VALUE_JOURNEY_TIME_ASCENDING
     * @uses self::VALUE_JOURNEY_TIME_DESCENDING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRICE_ASCENDING,
            self::VALUE_PRICE_DESCENDING,
            self::VALUE_DEPARTURE_TIME_ASCENDING,
            self::VALUE_DEPARTURE_TIME_DESCENDING,
            self::VALUE_ARRIVAL_TIME_ASCENDING,
            self::VALUE_ARRIVAL_TIME_DESCENDING,
            self::VALUE_JOURNEY_TIME_ASCENDING,
            self::VALUE_JOURNEY_TIME_DESCENDING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
