<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseDiagnostics StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ResponseDiagnostics
 * @subpackage Structs
 */
class ResponseDiagnostics extends AbstractStructBase
{
    /**
     * The CallingServiceTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $CallingServiceTime;
    /**
     * The GeneratingRequestTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $GeneratingRequestTime;
    /**
     * The GeneratingResponseTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $GeneratingResponseTime;
    /**
     * The LastException
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Fault
     */
    public $LastException;
    /**
     * The ProviderInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\ProviderInfo
     */
    public $ProviderInfo;
    /**
     * The ProviderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderName;
    /**
     * The ServiceRequestData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceRequestData;
    /**
     * The ServiceResponseData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceResponseData;
    /**
     * The SubDiagnostics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfResponseDiagnostics
     */
    public $SubDiagnostics;
    /**
     * Constructor method for ResponseDiagnostics
     * @uses ResponseDiagnostics::setCallingServiceTime()
     * @uses ResponseDiagnostics::setGeneratingRequestTime()
     * @uses ResponseDiagnostics::setGeneratingResponseTime()
     * @uses ResponseDiagnostics::setLastException()
     * @uses ResponseDiagnostics::setProviderInfo()
     * @uses ResponseDiagnostics::setProviderName()
     * @uses ResponseDiagnostics::setServiceRequestData()
     * @uses ResponseDiagnostics::setServiceResponseData()
     * @uses ResponseDiagnostics::setSubDiagnostics()
     * @param string $callingServiceTime
     * @param string $generatingRequestTime
     * @param string $generatingResponseTime
     * @param \TravelAccess\StructType\Fault $lastException
     * @param \TravelAccess\StructType\ProviderInfo $providerInfo
     * @param string $providerName
     * @param string $serviceRequestData
     * @param string $serviceResponseData
     * @param \TravelAccess\ArrayType\ArrayOfResponseDiagnostics $subDiagnostics
     */
    public function __construct($callingServiceTime = null, $generatingRequestTime = null, $generatingResponseTime = null, \TravelAccess\StructType\Fault $lastException = null, \TravelAccess\StructType\ProviderInfo $providerInfo = null, $providerName = null, $serviceRequestData = null, $serviceResponseData = null, \TravelAccess\ArrayType\ArrayOfResponseDiagnostics $subDiagnostics = null)
    {
        $this
            ->setCallingServiceTime($callingServiceTime)
            ->setGeneratingRequestTime($generatingRequestTime)
            ->setGeneratingResponseTime($generatingResponseTime)
            ->setLastException($lastException)
            ->setProviderInfo($providerInfo)
            ->setProviderName($providerName)
            ->setServiceRequestData($serviceRequestData)
            ->setServiceResponseData($serviceResponseData)
            ->setSubDiagnostics($subDiagnostics);
    }
    /**
     * Get CallingServiceTime value
     * @return string|null
     */
    public function getCallingServiceTime()
    {
        return $this->CallingServiceTime;
    }
    /**
     * Set CallingServiceTime value
     * @param string $callingServiceTime
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public function setCallingServiceTime($callingServiceTime = null)
    {
        // validation for constraint: maxInclusive
        if ($callingServiceTime > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $callingServiceTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($callingServiceTime < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $callingServiceTime), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($callingServiceTime) && !preg_match('/\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?/', $callingServiceTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($callingServiceTime, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingServiceTime) && !is_string($callingServiceTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingServiceTime)), __LINE__);
        }
        $this->CallingServiceTime = $callingServiceTime;
        return $this;
    }
    /**
     * Get GeneratingRequestTime value
     * @return string|null
     */
    public function getGeneratingRequestTime()
    {
        return $this->GeneratingRequestTime;
    }
    /**
     * Set GeneratingRequestTime value
     * @param string $generatingRequestTime
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public function setGeneratingRequestTime($generatingRequestTime = null)
    {
        // validation for constraint: maxInclusive
        if ($generatingRequestTime > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $generatingRequestTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($generatingRequestTime < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $generatingRequestTime), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($generatingRequestTime) && !preg_match('/\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?/', $generatingRequestTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($generatingRequestTime, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($generatingRequestTime) && !is_string($generatingRequestTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($generatingRequestTime)), __LINE__);
        }
        $this->GeneratingRequestTime = $generatingRequestTime;
        return $this;
    }
    /**
     * Get GeneratingResponseTime value
     * @return string|null
     */
    public function getGeneratingResponseTime()
    {
        return $this->GeneratingResponseTime;
    }
    /**
     * Set GeneratingResponseTime value
     * @param string $generatingResponseTime
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public function setGeneratingResponseTime($generatingResponseTime = null)
    {
        // validation for constraint: maxInclusive
        if ($generatingResponseTime > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $generatingResponseTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($generatingResponseTime < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $generatingResponseTime), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($generatingResponseTime) && !preg_match('/\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?/', $generatingResponseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($generatingResponseTime, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($generatingResponseTime) && !is_string($generatingResponseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($generatingResponseTime)), __LINE__);
        }
        $this->GeneratingResponseTime = $generatingResponseTime;
        return $this;
    }
    /**
     * Get LastException value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Fault|null
     */
    public function getLastException()
    {
        return isset($this->LastException) ? $this->LastException : null;
    }
    /**
     * Set LastException value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\Fault $lastException
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public function setLastException(\TravelAccess\StructType\Fault $lastException = null)
    {
        if (is_null($lastException) || (is_array($lastException) && empty($lastException))) {
            unset($this->LastException);
        } else {
            $this->LastException = $lastException;
        }
        return $this;
    }
    /**
     * Get ProviderInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\ProviderInfo|null
     */
    public function getProviderInfo()
    {
        return isset($this->ProviderInfo) ? $this->ProviderInfo : null;
    }
    /**
     * Set ProviderInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\ProviderInfo $providerInfo
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public function setProviderInfo(\TravelAccess\StructType\ProviderInfo $providerInfo = null)
    {
        if (is_null($providerInfo) || (is_array($providerInfo) && empty($providerInfo))) {
            unset($this->ProviderInfo);
        } else {
            $this->ProviderInfo = $providerInfo;
        }
        return $this;
    }
    /**
     * Get ProviderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderName()
    {
        return isset($this->ProviderName) ? $this->ProviderName : null;
    }
    /**
     * Set ProviderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerName
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public function setProviderName($providerName = null)
    {
        // validation for constraint: string
        if (!is_null($providerName) && !is_string($providerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerName)), __LINE__);
        }
        if (is_null($providerName) || (is_array($providerName) && empty($providerName))) {
            unset($this->ProviderName);
        } else {
            $this->ProviderName = $providerName;
        }
        return $this;
    }
    /**
     * Get ServiceRequestData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestData()
    {
        return isset($this->ServiceRequestData) ? $this->ServiceRequestData : null;
    }
    /**
     * Set ServiceRequestData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceRequestData
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public function setServiceRequestData($serviceRequestData = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestData) && !is_string($serviceRequestData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceRequestData)), __LINE__);
        }
        if (is_null($serviceRequestData) || (is_array($serviceRequestData) && empty($serviceRequestData))) {
            unset($this->ServiceRequestData);
        } else {
            $this->ServiceRequestData = $serviceRequestData;
        }
        return $this;
    }
    /**
     * Get ServiceResponseData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceResponseData()
    {
        return isset($this->ServiceResponseData) ? $this->ServiceResponseData : null;
    }
    /**
     * Set ServiceResponseData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceResponseData
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public function setServiceResponseData($serviceResponseData = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResponseData) && !is_string($serviceResponseData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceResponseData)), __LINE__);
        }
        if (is_null($serviceResponseData) || (is_array($serviceResponseData) && empty($serviceResponseData))) {
            unset($this->ServiceResponseData);
        } else {
            $this->ServiceResponseData = $serviceResponseData;
        }
        return $this;
    }
    /**
     * Get SubDiagnostics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfResponseDiagnostics|null
     */
    public function getSubDiagnostics()
    {
        return isset($this->SubDiagnostics) ? $this->SubDiagnostics : null;
    }
    /**
     * Set SubDiagnostics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfResponseDiagnostics $subDiagnostics
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public function setSubDiagnostics(\TravelAccess\ArrayType\ArrayOfResponseDiagnostics $subDiagnostics = null)
    {
        if (is_null($subDiagnostics) || (is_array($subDiagnostics) && empty($subDiagnostics))) {
            unset($this->SubDiagnostics);
        } else {
            $this->SubDiagnostics = $subDiagnostics;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\ResponseDiagnostics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
