<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationRecordOfPricingCombination StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationRecordOfPricingCombination
 * @subpackage Structs
 */
class ReservationRecordOfPricingCombination extends AbstractStructBase
{
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The OptionDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OptionDate;
    /**
     * The PassengerProductKeys
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfstring
     */
    public $PassengerProductKeys;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\PricingCombination
     */
    public $Product;
    /**
     * The ReservationKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationKey;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Version;
    /**
     * Constructor method for ReservationRecordOfPricingCombination
     * @uses ReservationRecordOfPricingCombination::setCreateDate()
     * @uses ReservationRecordOfPricingCombination::setOptionDate()
     * @uses ReservationRecordOfPricingCombination::setPassengerProductKeys()
     * @uses ReservationRecordOfPricingCombination::setProduct()
     * @uses ReservationRecordOfPricingCombination::setReservationKey()
     * @uses ReservationRecordOfPricingCombination::setStatus()
     * @uses ReservationRecordOfPricingCombination::setVersion()
     * @param string $createDate
     * @param string $optionDate
     * @param \TravelAccess\ArrayType\ArrayOfstring $passengerProductKeys
     * @param \TravelAccess\StructType\PricingCombination $product
     * @param string $reservationKey
     * @param string $status
     * @param int $version
     */
    public function __construct($createDate = null, $optionDate = null, \TravelAccess\ArrayType\ArrayOfstring $passengerProductKeys = null, \TravelAccess\StructType\PricingCombination $product = null, $reservationKey = null, $status = null, $version = null)
    {
        $this
            ->setCreateDate($createDate)
            ->setOptionDate($optionDate)
            ->setPassengerProductKeys($passengerProductKeys)
            ->setProduct($product)
            ->setReservationKey($reservationKey)
            ->setStatus($status)
            ->setVersion($version);
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \TravelAccess\StructType\ReservationRecordOfPricingCombination
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get OptionDate value
     * @return string|null
     */
    public function getOptionDate()
    {
        return $this->OptionDate;
    }
    /**
     * Set OptionDate value
     * @param string $optionDate
     * @return \TravelAccess\StructType\ReservationRecordOfPricingCombination
     */
    public function setOptionDate($optionDate = null)
    {
        // validation for constraint: string
        if (!is_null($optionDate) && !is_string($optionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optionDate)), __LINE__);
        }
        $this->OptionDate = $optionDate;
        return $this;
    }
    /**
     * Get PassengerProductKeys value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfstring|null
     */
    public function getPassengerProductKeys()
    {
        return isset($this->PassengerProductKeys) ? $this->PassengerProductKeys : null;
    }
    /**
     * Set PassengerProductKeys value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfstring $passengerProductKeys
     * @return \TravelAccess\StructType\ReservationRecordOfPricingCombination
     */
    public function setPassengerProductKeys(\TravelAccess\ArrayType\ArrayOfstring $passengerProductKeys = null)
    {
        if (is_null($passengerProductKeys) || (is_array($passengerProductKeys) && empty($passengerProductKeys))) {
            unset($this->PassengerProductKeys);
        } else {
            $this->PassengerProductKeys = $passengerProductKeys;
        }
        return $this;
    }
    /**
     * Get Product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\PricingCombination|null
     */
    public function getProduct()
    {
        return isset($this->Product) ? $this->Product : null;
    }
    /**
     * Set Product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\PricingCombination $product
     * @return \TravelAccess\StructType\ReservationRecordOfPricingCombination
     */
    public function setProduct(\TravelAccess\StructType\PricingCombination $product = null)
    {
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->Product);
        } else {
            $this->Product = $product;
        }
        return $this;
    }
    /**
     * Get ReservationKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationKey()
    {
        return isset($this->ReservationKey) ? $this->ReservationKey : null;
    }
    /**
     * Set ReservationKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationKey
     * @return \TravelAccess\StructType\ReservationRecordOfPricingCombination
     */
    public function setReservationKey($reservationKey = null)
    {
        // validation for constraint: string
        if (!is_null($reservationKey) && !is_string($reservationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationKey)), __LINE__);
        }
        if (is_null($reservationKey) || (is_array($reservationKey) && empty($reservationKey))) {
            unset($this->ReservationKey);
        } else {
            $this->ReservationKey = $reservationKey;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \TravelAccess\EnumType\RecordStatus::valueIsValid()
     * @uses \TravelAccess\EnumType\RecordStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \TravelAccess\StructType\ReservationRecordOfPricingCombination
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\TravelAccess\EnumType\RecordStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \TravelAccess\EnumType\RecordStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param int $version
     * @return \TravelAccess\StructType\ReservationRecordOfPricingCombination
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\ReservationRecordOfPricingCombination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
