<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProviderInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProviderInfo
 * @subpackage Structs
 */
class ProviderInfo extends AbstractStructBase
{
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The IsProduction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsProduction;
    /**
     * Constructor method for ProviderInfo
     * @uses ProviderInfo::setIsActive()
     * @uses ProviderInfo::setIsProduction()
     * @param bool $isActive
     * @param bool $isProduction
     */
    public function __construct($isActive = null, $isProduction = null)
    {
        $this
            ->setIsActive($isActive)
            ->setIsProduction($isProduction);
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \TravelAccess\StructType\ProviderInfo
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsProduction value
     * @return bool|null
     */
    public function getIsProduction()
    {
        return $this->IsProduction;
    }
    /**
     * Set IsProduction value
     * @param bool $isProduction
     * @return \TravelAccess\StructType\ProviderInfo
     */
    public function setIsProduction($isProduction = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProduction) && !is_bool($isProduction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isProduction)), __LINE__);
        }
        $this->IsProduction = $isProduction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\ProviderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
