<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerPrice StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerPrice
 * @subpackage Structs
 */
class PassengerPrice extends AbstractStructBase
{
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfSearchPassenger
     */
    public $Passengers;
    /**
     * The UnitBasePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \TravelAccess\StructType\Price
     */
    public $UnitBasePrice;
    /**
     * The UnitFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \TravelAccess\StructType\Fee
     */
    public $UnitFee;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \TravelAccess\StructType\Price
     */
    public $UnitPrice;
    /**
     * The UnitTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \TravelAccess\StructType\Price
     */
    public $UnitTax;
    /**
     * Constructor method for PassengerPrice
     * @uses PassengerPrice::setPassengers()
     * @uses PassengerPrice::setUnitBasePrice()
     * @uses PassengerPrice::setUnitFee()
     * @uses PassengerPrice::setUnitPrice()
     * @uses PassengerPrice::setUnitTax()
     * @param \TravelAccess\ArrayType\ArrayOfSearchPassenger $passengers
     * @param \TravelAccess\StructType\Price $unitBasePrice
     * @param \TravelAccess\StructType\Fee $unitFee
     * @param \TravelAccess\StructType\Price $unitPrice
     * @param \TravelAccess\StructType\Price $unitTax
     */
    public function __construct(\TravelAccess\ArrayType\ArrayOfSearchPassenger $passengers = null, \TravelAccess\StructType\Price $unitBasePrice = null, \TravelAccess\StructType\Fee $unitFee = null, \TravelAccess\StructType\Price $unitPrice = null, \TravelAccess\StructType\Price $unitTax = null)
    {
        $this
            ->setPassengers($passengers)
            ->setUnitBasePrice($unitBasePrice)
            ->setUnitFee($unitFee)
            ->setUnitPrice($unitPrice)
            ->setUnitTax($unitTax);
    }
    /**
     * Get Passengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfSearchPassenger|null
     */
    public function getPassengers()
    {
        return isset($this->Passengers) ? $this->Passengers : null;
    }
    /**
     * Set Passengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfSearchPassenger $passengers
     * @return \TravelAccess\StructType\PassengerPrice
     */
    public function setPassengers(\TravelAccess\ArrayType\ArrayOfSearchPassenger $passengers = null)
    {
        if (is_null($passengers) || (is_array($passengers) && empty($passengers))) {
            unset($this->Passengers);
        } else {
            $this->Passengers = $passengers;
        }
        return $this;
    }
    /**
     * Get UnitBasePrice value
     * @return \TravelAccess\StructType\Price|null
     */
    public function getUnitBasePrice()
    {
        return $this->UnitBasePrice;
    }
    /**
     * Set UnitBasePrice value
     * @param \TravelAccess\StructType\Price $unitBasePrice
     * @return \TravelAccess\StructType\PassengerPrice
     */
    public function setUnitBasePrice(\TravelAccess\StructType\Price $unitBasePrice = null)
    {
        $this->UnitBasePrice = $unitBasePrice;
        return $this;
    }
    /**
     * Get UnitFee value
     * @return \TravelAccess\StructType\Fee|null
     */
    public function getUnitFee()
    {
        return $this->UnitFee;
    }
    /**
     * Set UnitFee value
     * @param \TravelAccess\StructType\Fee $unitFee
     * @return \TravelAccess\StructType\PassengerPrice
     */
    public function setUnitFee(\TravelAccess\StructType\Fee $unitFee = null)
    {
        $this->UnitFee = $unitFee;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return \TravelAccess\StructType\Price|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param \TravelAccess\StructType\Price $unitPrice
     * @return \TravelAccess\StructType\PassengerPrice
     */
    public function setUnitPrice(\TravelAccess\StructType\Price $unitPrice = null)
    {
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get UnitTax value
     * @return \TravelAccess\StructType\Price|null
     */
    public function getUnitTax()
    {
        return $this->UnitTax;
    }
    /**
     * Set UnitTax value
     * @param \TravelAccess\StructType\Price $unitTax
     * @return \TravelAccess\StructType\PassengerPrice
     */
    public function setUnitTax(\TravelAccess\StructType\Price $unitTax = null)
    {
        $this->UnitTax = $unitTax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\PassengerPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
