<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CombinationGroup StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q34:CombinationGroup
 * @subpackage Structs
 */
class CombinationGroup extends TravelProduct
{
    /**
     * The FlightSegmentKeys
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfstring
     */
    public $FlightSegmentKeys;
    /**
     * The FlightSegments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfFlightSegment
     */
    public $FlightSegments;
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GroupId;
    /**
     * The TravelTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $TravelTime;
    /**
     * Constructor method for CombinationGroup
     * @uses CombinationGroup::setFlightSegmentKeys()
     * @uses CombinationGroup::setFlightSegments()
     * @uses CombinationGroup::setGroupId()
     * @uses CombinationGroup::setTravelTime()
     * @param \TravelAccess\ArrayType\ArrayOfstring $flightSegmentKeys
     * @param \TravelAccess\ArrayType\ArrayOfFlightSegment $flightSegments
     * @param int $groupId
     * @param string $travelTime
     */
    public function __construct(\TravelAccess\ArrayType\ArrayOfstring $flightSegmentKeys = null, \TravelAccess\ArrayType\ArrayOfFlightSegment $flightSegments = null, $groupId = null, $travelTime = null)
    {
        $this
            ->setFlightSegmentKeys($flightSegmentKeys)
            ->setFlightSegments($flightSegments)
            ->setGroupId($groupId)
            ->setTravelTime($travelTime);
    }
    /**
     * Get FlightSegmentKeys value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfstring|null
     */
    public function getFlightSegmentKeys()
    {
        return isset($this->FlightSegmentKeys) ? $this->FlightSegmentKeys : null;
    }
    /**
     * Set FlightSegmentKeys value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfstring $flightSegmentKeys
     * @return \TravelAccess\StructType\CombinationGroup
     */
    public function setFlightSegmentKeys(\TravelAccess\ArrayType\ArrayOfstring $flightSegmentKeys = null)
    {
        if (is_null($flightSegmentKeys) || (is_array($flightSegmentKeys) && empty($flightSegmentKeys))) {
            unset($this->FlightSegmentKeys);
        } else {
            $this->FlightSegmentKeys = $flightSegmentKeys;
        }
        return $this;
    }
    /**
     * Get FlightSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfFlightSegment|null
     */
    public function getFlightSegments()
    {
        return isset($this->FlightSegments) ? $this->FlightSegments : null;
    }
    /**
     * Set FlightSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfFlightSegment $flightSegments
     * @return \TravelAccess\StructType\CombinationGroup
     */
    public function setFlightSegments(\TravelAccess\ArrayType\ArrayOfFlightSegment $flightSegments = null)
    {
        if (is_null($flightSegments) || (is_array($flightSegments) && empty($flightSegments))) {
            unset($this->FlightSegments);
        } else {
            $this->FlightSegments = $flightSegments;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * @return int|null
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \TravelAccess\StructType\CombinationGroup
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !is_numeric($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get TravelTime value
     * @return string|null
     */
    public function getTravelTime()
    {
        return $this->TravelTime;
    }
    /**
     * Set TravelTime value
     * @param string $travelTime
     * @return \TravelAccess\StructType\CombinationGroup
     */
    public function setTravelTime($travelTime = null)
    {
        // validation for constraint: maxInclusive
        if ($travelTime > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $travelTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($travelTime < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $travelTime), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($travelTime) && !preg_match('/\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?/', $travelTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($travelTime, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($travelTime) && !is_string($travelTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelTime)), __LINE__);
        }
        $this->TravelTime = $travelTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\CombinationGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
