<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingPassenger StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BookingPassenger
 * @subpackage Structs
 */
class BookingPassenger extends SearchPassenger
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Address
     */
    public $Address;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Country
     */
    public $Country;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The IsMaster
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMaster;
    /**
     * The MobilPhoneNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfPhoneNumber
     */
    public $MobilPhoneNumbers;
    /**
     * The PhoneNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfPhoneNumber
     */
    public $PhoneNumbers;
    /**
     * The Prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prefix;
    /**
     * The SpecialServiceRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\ArrayType\ArrayOfSpecialServiceRequest
     */
    public $SpecialServiceRequests;
    /**
     * The Suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * The TcKimlikNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TcKimlikNo;
    /**
     * Constructor method for BookingPassenger
     * @uses BookingPassenger::setAddress()
     * @uses BookingPassenger::setCountry()
     * @uses BookingPassenger::setEmail()
     * @uses BookingPassenger::setIsMaster()
     * @uses BookingPassenger::setMobilPhoneNumbers()
     * @uses BookingPassenger::setPhoneNumbers()
     * @uses BookingPassenger::setPrefix()
     * @uses BookingPassenger::setSpecialServiceRequests()
     * @uses BookingPassenger::setSuffix()
     * @uses BookingPassenger::setTcKimlikNo()
     * @param \TravelAccess\StructType\Address $address
     * @param \TravelAccess\StructType\Country $country
     * @param string $email
     * @param bool $isMaster
     * @param \TravelAccess\ArrayType\ArrayOfPhoneNumber $mobilPhoneNumbers
     * @param \TravelAccess\ArrayType\ArrayOfPhoneNumber $phoneNumbers
     * @param string $prefix
     * @param \TravelAccess\ArrayType\ArrayOfSpecialServiceRequest $specialServiceRequests
     * @param string $suffix
     * @param string $tcKimlikNo
     */
    public function __construct(\TravelAccess\StructType\Address $address = null, \TravelAccess\StructType\Country $country = null, $email = null, $isMaster = null, \TravelAccess\ArrayType\ArrayOfPhoneNumber $mobilPhoneNumbers = null, \TravelAccess\ArrayType\ArrayOfPhoneNumber $phoneNumbers = null, $prefix = null, \TravelAccess\ArrayType\ArrayOfSpecialServiceRequest $specialServiceRequests = null, $suffix = null, $tcKimlikNo = null)
    {
        $this
            ->setAddress($address)
            ->setCountry($country)
            ->setEmail($email)
            ->setIsMaster($isMaster)
            ->setMobilPhoneNumbers($mobilPhoneNumbers)
            ->setPhoneNumbers($phoneNumbers)
            ->setPrefix($prefix)
            ->setSpecialServiceRequests($specialServiceRequests)
            ->setSuffix($suffix)
            ->setTcKimlikNo($tcKimlikNo);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\Address $address
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setAddress(\TravelAccess\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Country|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\Country $country
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setCountry(\TravelAccess\StructType\Country $country = null)
    {
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get IsMaster value
     * @return bool|null
     */
    public function getIsMaster()
    {
        return $this->IsMaster;
    }
    /**
     * Set IsMaster value
     * @param bool $isMaster
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setIsMaster($isMaster = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMaster) && !is_bool($isMaster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMaster)), __LINE__);
        }
        $this->IsMaster = $isMaster;
        return $this;
    }
    /**
     * Get MobilPhoneNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfPhoneNumber|null
     */
    public function getMobilPhoneNumbers()
    {
        return isset($this->MobilPhoneNumbers) ? $this->MobilPhoneNumbers : null;
    }
    /**
     * Set MobilPhoneNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfPhoneNumber $mobilPhoneNumbers
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setMobilPhoneNumbers(\TravelAccess\ArrayType\ArrayOfPhoneNumber $mobilPhoneNumbers = null)
    {
        if (is_null($mobilPhoneNumbers) || (is_array($mobilPhoneNumbers) && empty($mobilPhoneNumbers))) {
            unset($this->MobilPhoneNumbers);
        } else {
            $this->MobilPhoneNumbers = $mobilPhoneNumbers;
        }
        return $this;
    }
    /**
     * Get PhoneNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfPhoneNumber|null
     */
    public function getPhoneNumbers()
    {
        return isset($this->PhoneNumbers) ? $this->PhoneNumbers : null;
    }
    /**
     * Set PhoneNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfPhoneNumber $phoneNumbers
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setPhoneNumbers(\TravelAccess\ArrayType\ArrayOfPhoneNumber $phoneNumbers = null)
    {
        if (is_null($phoneNumbers) || (is_array($phoneNumbers) && empty($phoneNumbers))) {
            unset($this->PhoneNumbers);
        } else {
            $this->PhoneNumbers = $phoneNumbers;
        }
        return $this;
    }
    /**
     * Get Prefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefix()
    {
        return isset($this->Prefix) ? $this->Prefix : null;
    }
    /**
     * Set Prefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefix
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        if (is_null($prefix) || (is_array($prefix) && empty($prefix))) {
            unset($this->Prefix);
        } else {
            $this->Prefix = $prefix;
        }
        return $this;
    }
    /**
     * Get SpecialServiceRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\ArrayType\ArrayOfSpecialServiceRequest|null
     */
    public function getSpecialServiceRequests()
    {
        return isset($this->SpecialServiceRequests) ? $this->SpecialServiceRequests : null;
    }
    /**
     * Set SpecialServiceRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\ArrayType\ArrayOfSpecialServiceRequest $specialServiceRequests
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setSpecialServiceRequests(\TravelAccess\ArrayType\ArrayOfSpecialServiceRequest $specialServiceRequests = null)
    {
        if (is_null($specialServiceRequests) || (is_array($specialServiceRequests) && empty($specialServiceRequests))) {
            unset($this->SpecialServiceRequests);
        } else {
            $this->SpecialServiceRequests = $specialServiceRequests;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Get TcKimlikNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTcKimlikNo()
    {
        return isset($this->TcKimlikNo) ? $this->TcKimlikNo : null;
    }
    /**
     * Set TcKimlikNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tcKimlikNo
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public function setTcKimlikNo($tcKimlikNo = null)
    {
        // validation for constraint: string
        if (!is_null($tcKimlikNo) && !is_string($tcKimlikNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tcKimlikNo)), __LINE__);
        }
        if (is_null($tcKimlikNo) || (is_array($tcKimlikNo) && empty($tcKimlikNo))) {
            unset($this->TcKimlikNo);
        } else {
            $this->TcKimlikNo = $tcKimlikNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\BookingPassenger
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
