<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseResponse
 * @subpackage Structs
 */
class BaseResponse extends AbstractStructBase
{
    /**
     * The Diagnostics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\ResponseDiagnostics
     */
    public $Diagnostics;
    /**
     * The TraceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TraceId;
    /**
     * Constructor method for BaseResponse
     * @uses BaseResponse::setDiagnostics()
     * @uses BaseResponse::setTraceId()
     * @param \TravelAccess\StructType\ResponseDiagnostics $diagnostics
     * @param string $traceId
     */
    public function __construct(\TravelAccess\StructType\ResponseDiagnostics $diagnostics = null, $traceId = null)
    {
        $this
            ->setDiagnostics($diagnostics)
            ->setTraceId($traceId);
    }
    /**
     * Get Diagnostics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\ResponseDiagnostics|null
     */
    public function getDiagnostics()
    {
        return isset($this->Diagnostics) ? $this->Diagnostics : null;
    }
    /**
     * Set Diagnostics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \TravelAccess\StructType\ResponseDiagnostics $diagnostics
     * @return \TravelAccess\StructType\BaseResponse
     */
    public function setDiagnostics(\TravelAccess\StructType\ResponseDiagnostics $diagnostics = null)
    {
        if (is_null($diagnostics) || (is_array($diagnostics) && empty($diagnostics))) {
            unset($this->Diagnostics);
        } else {
            $this->Diagnostics = $diagnostics;
        }
        return $this;
    }
    /**
     * Get TraceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTraceId()
    {
        return isset($this->TraceId) ? $this->TraceId : null;
    }
    /**
     * Set TraceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $traceId
     * @return \TravelAccess\StructType\BaseResponse
     */
    public function setTraceId($traceId = null)
    {
        // validation for constraint: string
        if (!is_null($traceId) && !is_string($traceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceId)), __LINE__);
        }
        if (is_null($traceId) || (is_array($traceId) && empty($traceId))) {
            unset($this->TraceId);
        } else {
            $this->TraceId = $traceId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\BaseResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
