<?php

namespace TravelAccess\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgeValidationInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AgeValidationInformation
 * @subpackage Structs
 */
class AgeValidationInformation extends AbstractStructBase
{
    /**
     * The AdultAgeBegin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdultAgeBegin;
    /**
     * The AgeReferenceDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AgeReferenceDate;
    /**
     * The ChildAgeBegin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChildAgeBegin;
    /**
     * The InfantAgeBegin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $InfantAgeBegin;
    /**
     * Constructor method for AgeValidationInformation
     * @uses AgeValidationInformation::setAdultAgeBegin()
     * @uses AgeValidationInformation::setAgeReferenceDate()
     * @uses AgeValidationInformation::setChildAgeBegin()
     * @uses AgeValidationInformation::setInfantAgeBegin()
     * @param int $adultAgeBegin
     * @param string $ageReferenceDate
     * @param int $childAgeBegin
     * @param string $infantAgeBegin
     */
    public function __construct($adultAgeBegin = null, $ageReferenceDate = null, $childAgeBegin = null, $infantAgeBegin = null)
    {
        $this
            ->setAdultAgeBegin($adultAgeBegin)
            ->setAgeReferenceDate($ageReferenceDate)
            ->setChildAgeBegin($childAgeBegin)
            ->setInfantAgeBegin($infantAgeBegin);
    }
    /**
     * Get AdultAgeBegin value
     * @return int|null
     */
    public function getAdultAgeBegin()
    {
        return $this->AdultAgeBegin;
    }
    /**
     * Set AdultAgeBegin value
     * @param int $adultAgeBegin
     * @return \TravelAccess\StructType\AgeValidationInformation
     */
    public function setAdultAgeBegin($adultAgeBegin = null)
    {
        // validation for constraint: int
        if (!is_null($adultAgeBegin) && !is_numeric($adultAgeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adultAgeBegin)), __LINE__);
        }
        $this->AdultAgeBegin = $adultAgeBegin;
        return $this;
    }
    /**
     * Get AgeReferenceDate value
     * @return string|null
     */
    public function getAgeReferenceDate()
    {
        return $this->AgeReferenceDate;
    }
    /**
     * Set AgeReferenceDate value
     * @param string $ageReferenceDate
     * @return \TravelAccess\StructType\AgeValidationInformation
     */
    public function setAgeReferenceDate($ageReferenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($ageReferenceDate) && !is_string($ageReferenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ageReferenceDate)), __LINE__);
        }
        $this->AgeReferenceDate = $ageReferenceDate;
        return $this;
    }
    /**
     * Get ChildAgeBegin value
     * @return int|null
     */
    public function getChildAgeBegin()
    {
        return $this->ChildAgeBegin;
    }
    /**
     * Set ChildAgeBegin value
     * @param int $childAgeBegin
     * @return \TravelAccess\StructType\AgeValidationInformation
     */
    public function setChildAgeBegin($childAgeBegin = null)
    {
        // validation for constraint: int
        if (!is_null($childAgeBegin) && !is_numeric($childAgeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childAgeBegin)), __LINE__);
        }
        $this->ChildAgeBegin = $childAgeBegin;
        return $this;
    }
    /**
     * Get InfantAgeBegin value
     * @return string|null
     */
    public function getInfantAgeBegin()
    {
        return $this->InfantAgeBegin;
    }
    /**
     * Set InfantAgeBegin value
     * @param string $infantAgeBegin
     * @return \TravelAccess\StructType\AgeValidationInformation
     */
    public function setInfantAgeBegin($infantAgeBegin = null)
    {
        // validation for constraint: maxInclusive
        if ($infantAgeBegin > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $infantAgeBegin), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($infantAgeBegin < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $infantAgeBegin), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($infantAgeBegin) && !preg_match('/\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?/', $infantAgeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($infantAgeBegin, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($infantAgeBegin) && !is_string($infantAgeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infantAgeBegin)), __LINE__);
        }
        $this->InfantAgeBegin = $infantAgeBegin;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\StructType\AgeValidationInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
