<?php

namespace TravelAccess\EnumType;

/**
 * This class stands for CabinClass EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q14:CabinClass
 * @subpackage Enumerations
 */
class CabinClass
{
    /**
     * Constant for value 'Economy'
     * @return string 'Economy'
     */
    const VALUE_ECONOMY = 'Economy';
    /**
     * Constant for value 'Comfort'
     * @return string 'Comfort'
     */
    const VALUE_COMFORT = 'Comfort';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'First'
     * @return string 'First'
     */
    const VALUE_FIRST = 'First';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ECONOMY
     * @uses self::VALUE_COMFORT
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_FIRST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ECONOMY,
            self::VALUE_COMFORT,
            self::VALUE_BUSINESS,
            self::VALUE_FIRST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
