<?php

namespace TravelAccess\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialServiceRequest ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSpecialServiceRequest
 * @subpackage Arrays
 */
class ArrayOfSpecialServiceRequest extends AbstractStructArrayBase
{
    /**
     * The SpecialServiceRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\SpecialServiceRequest[]
     */
    public $SpecialServiceRequest;
    /**
     * Constructor method for ArrayOfSpecialServiceRequest
     * @uses ArrayOfSpecialServiceRequest::setSpecialServiceRequest()
     * @param \TravelAccess\StructType\SpecialServiceRequest[] $specialServiceRequest
     */
    public function __construct(array $specialServiceRequest = array())
    {
        $this
            ->setSpecialServiceRequest($specialServiceRequest);
    }
    /**
     * Get SpecialServiceRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\SpecialServiceRequest[]|null
     */
    public function getSpecialServiceRequest()
    {
        return isset($this->SpecialServiceRequest) ? $this->SpecialServiceRequest : null;
    }
    /**
     * Set SpecialServiceRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\SpecialServiceRequest[] $specialServiceRequest
     * @return \TravelAccess\ArrayType\ArrayOfSpecialServiceRequest
     */
    public function setSpecialServiceRequest(array $specialServiceRequest = array())
    {
        foreach ($specialServiceRequest as $arrayOfSpecialServiceRequestSpecialServiceRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialServiceRequestSpecialServiceRequestItem instanceof \TravelAccess\StructType\SpecialServiceRequest) {
                throw new \InvalidArgumentException(sprintf('The SpecialServiceRequest property can only contain items of \TravelAccess\StructType\SpecialServiceRequest, "%s" given', is_object($arrayOfSpecialServiceRequestSpecialServiceRequestItem) ? get_class($arrayOfSpecialServiceRequestSpecialServiceRequestItem) : gettype($arrayOfSpecialServiceRequestSpecialServiceRequestItem)), __LINE__);
            }
        }
        if (is_null($specialServiceRequest) || (is_array($specialServiceRequest) && empty($specialServiceRequest))) {
            unset($this->SpecialServiceRequest);
        } else {
            $this->SpecialServiceRequest = $specialServiceRequest;
        }
        return $this;
    }
    /**
     * Add item to SpecialServiceRequest value
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\SpecialServiceRequest $item
     * @return \TravelAccess\ArrayType\ArrayOfSpecialServiceRequest
     */
    public function addToSpecialServiceRequest(\TravelAccess\StructType\SpecialServiceRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TravelAccess\StructType\SpecialServiceRequest) {
            throw new \InvalidArgumentException(sprintf('The SpecialServiceRequest property can only contain items of \TravelAccess\StructType\SpecialServiceRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialServiceRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TravelAccess\StructType\SpecialServiceRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TravelAccess\StructType\SpecialServiceRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TravelAccess\StructType\SpecialServiceRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TravelAccess\StructType\SpecialServiceRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TravelAccess\StructType\SpecialServiceRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialServiceRequest
     */
    public function getAttributeName()
    {
        return 'SpecialServiceRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\ArrayType\ArrayOfSpecialServiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
