<?php

namespace TravelAccess\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFault ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfFault
 * @subpackage Arrays
 */
class ArrayOfFault extends AbstractStructArrayBase
{
    /**
     * The Fault
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TravelAccess\StructType\Fault[]
     */
    public $Fault;
    /**
     * Constructor method for ArrayOfFault
     * @uses ArrayOfFault::setFault()
     * @param \TravelAccess\StructType\Fault[] $fault
     */
    public function __construct(array $fault = array())
    {
        $this
            ->setFault($fault);
    }
    /**
     * Get Fault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TravelAccess\StructType\Fault[]|null
     */
    public function getFault()
    {
        return isset($this->Fault) ? $this->Fault : null;
    }
    /**
     * Set Fault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\Fault[] $fault
     * @return \TravelAccess\ArrayType\ArrayOfFault
     */
    public function setFault(array $fault = array())
    {
        foreach ($fault as $arrayOfFaultFaultItem) {
            // validation for constraint: itemType
            if (!$arrayOfFaultFaultItem instanceof \TravelAccess\StructType\Fault) {
                throw new \InvalidArgumentException(sprintf('The Fault property can only contain items of \TravelAccess\StructType\Fault, "%s" given', is_object($arrayOfFaultFaultItem) ? get_class($arrayOfFaultFaultItem) : gettype($arrayOfFaultFaultItem)), __LINE__);
            }
        }
        if (is_null($fault) || (is_array($fault) && empty($fault))) {
            unset($this->Fault);
        } else {
            $this->Fault = $fault;
        }
        return $this;
    }
    /**
     * Add item to Fault value
     * @throws \InvalidArgumentException
     * @param \TravelAccess\StructType\Fault $item
     * @return \TravelAccess\ArrayType\ArrayOfFault
     */
    public function addToFault(\TravelAccess\StructType\Fault $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TravelAccess\StructType\Fault) {
            throw new \InvalidArgumentException(sprintf('The Fault property can only contain items of \TravelAccess\StructType\Fault, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Fault[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \TravelAccess\StructType\Fault|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \TravelAccess\StructType\Fault|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \TravelAccess\StructType\Fault|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \TravelAccess\StructType\Fault|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \TravelAccess\StructType\Fault|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Fault
     */
    public function getAttributeName()
    {
        return 'Fault';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \TravelAccess\ArrayType\ArrayOfFault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
