<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddNewInquiry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddNewInquiry $parameters
     * @return \StructType\AddNewInquiryResponse|bool
     */
    public function AddNewInquiry(\StructType\AddNewInquiry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddNewInquiry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddNewInquiryWithCV
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddNewInquiryWithCV $parameters
     * @return \StructType\AddNewInquiryWithCVResponse|bool
     */
    public function AddNewInquiryWithCV(\StructType\AddNewInquiryWithCV $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddNewInquiryWithCV($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddNewInquiryResponse|\StructType\AddNewInquiryWithCVResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
