<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetReportURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReportURL $parameters
     * @return \StructType\GetReportURLResponse|bool
     */
    public function GetReportURL(\StructType\GetReportURL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReportURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReportType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReportType $parameters
     * @return \StructType\GetReportTypeResponse|bool
     */
    public function GetReportType(\StructType\GetReportType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReportType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMediaScoreNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaScoreNumber $parameters
     * @return \StructType\GetMediaScoreNumberResponse|bool
     */
    public function GetMediaScoreNumber(\StructType\GetMediaScoreNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMediaScoreNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMediaScorePercentage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaScorePercentage $parameters
     * @return \StructType\GetMediaScorePercentageResponse|bool
     */
    public function GetMediaScorePercentage(\StructType\GetMediaScorePercentage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMediaScorePercentage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMediaRiskLevel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaRiskLevel $parameters
     * @return \StructType\GetMediaRiskLevelResponse|bool
     */
    public function GetMediaRiskLevel(\StructType\GetMediaRiskLevel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMediaRiskLevel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReportUrgency
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReportUrgency $parameters
     * @return \StructType\GetReportUrgencyResponse|bool
     */
    public function GetReportUrgency(\StructType\GetReportUrgency $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReportUrgency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetMediaRiskLevelResponse|\StructType\GetMediaScoreNumberResponse|\StructType\GetMediaScorePercentageResponse|\StructType\GetReportTypeResponse|\StructType\GetReportUrgencyResponse|\StructType\GetReportURLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
