<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentDataOutput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipmentDataOutput
 * @subpackage Structs
 */
class ShipmentDataOutput extends AbstractStructBase
{
    /**
     * The ClientReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReference;
    /**
     * The DocumentsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDocumentData
     */
    public $DocumentsList;
    /**
     * The FirstObject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstObject;
    /**
     * The LabelList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLabelData
     */
    public $LabelList;
    /**
     * The LastObject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastObject;
    /**
     * The OriginalObjectID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalObjectID;
    /**
     * Constructor method for ShipmentDataOutput
     * @uses ShipmentDataOutput::setClientReference()
     * @uses ShipmentDataOutput::setDocumentsList()
     * @uses ShipmentDataOutput::setFirstObject()
     * @uses ShipmentDataOutput::setLabelList()
     * @uses ShipmentDataOutput::setLastObject()
     * @uses ShipmentDataOutput::setOriginalObjectID()
     * @param string $clientReference
     * @param \ArrayType\ArrayOfDocumentData $documentsList
     * @param string $firstObject
     * @param \ArrayType\ArrayOfLabelData $labelList
     * @param string $lastObject
     * @param string $originalObjectID
     */
    public function __construct($clientReference = null, \ArrayType\ArrayOfDocumentData $documentsList = null, $firstObject = null, \ArrayType\ArrayOfLabelData $labelList = null, $lastObject = null, $originalObjectID = null)
    {
        $this
            ->setClientReference($clientReference)
            ->setDocumentsList($documentsList)
            ->setFirstObject($firstObject)
            ->setLabelList($labelList)
            ->setLastObject($lastObject)
            ->setOriginalObjectID($originalObjectID);
    }
    /**
     * Get ClientReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReference()
    {
        return isset($this->ClientReference) ? $this->ClientReference : null;
    }
    /**
     * Set ClientReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReference
     * @return \StructType\ShipmentDataOutput
     */
    public function setClientReference($clientReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientReference) && !is_string($clientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientReference, true), gettype($clientReference)), __LINE__);
        }
        if (is_null($clientReference) || (is_array($clientReference) && empty($clientReference))) {
            unset($this->ClientReference);
        } else {
            $this->ClientReference = $clientReference;
        }
        return $this;
    }
    /**
     * Get DocumentsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDocumentData|null
     */
    public function getDocumentsList()
    {
        return isset($this->DocumentsList) ? $this->DocumentsList : null;
    }
    /**
     * Set DocumentsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDocumentData $documentsList
     * @return \StructType\ShipmentDataOutput
     */
    public function setDocumentsList(\ArrayType\ArrayOfDocumentData $documentsList = null)
    {
        if (is_null($documentsList) || (is_array($documentsList) && empty($documentsList))) {
            unset($this->DocumentsList);
        } else {
            $this->DocumentsList = $documentsList;
        }
        return $this;
    }
    /**
     * Get FirstObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstObject()
    {
        return isset($this->FirstObject) ? $this->FirstObject : null;
    }
    /**
     * Set FirstObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstObject
     * @return \StructType\ShipmentDataOutput
     */
    public function setFirstObject($firstObject = null)
    {
        // validation for constraint: string
        if (!is_null($firstObject) && !is_string($firstObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstObject, true), gettype($firstObject)), __LINE__);
        }
        if (is_null($firstObject) || (is_array($firstObject) && empty($firstObject))) {
            unset($this->FirstObject);
        } else {
            $this->FirstObject = $firstObject;
        }
        return $this;
    }
    /**
     * Get LabelList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLabelData|null
     */
    public function getLabelList()
    {
        return isset($this->LabelList) ? $this->LabelList : null;
    }
    /**
     * Set LabelList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLabelData $labelList
     * @return \StructType\ShipmentDataOutput
     */
    public function setLabelList(\ArrayType\ArrayOfLabelData $labelList = null)
    {
        if (is_null($labelList) || (is_array($labelList) && empty($labelList))) {
            unset($this->LabelList);
        } else {
            $this->LabelList = $labelList;
        }
        return $this;
    }
    /**
     * Get LastObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastObject()
    {
        return isset($this->LastObject) ? $this->LastObject : null;
    }
    /**
     * Set LastObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastObject
     * @return \StructType\ShipmentDataOutput
     */
    public function setLastObject($lastObject = null)
    {
        // validation for constraint: string
        if (!is_null($lastObject) && !is_string($lastObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastObject, true), gettype($lastObject)), __LINE__);
        }
        if (is_null($lastObject) || (is_array($lastObject) && empty($lastObject))) {
            unset($this->LastObject);
        } else {
            $this->LastObject = $lastObject;
        }
        return $this;
    }
    /**
     * Get OriginalObjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalObjectID()
    {
        return isset($this->OriginalObjectID) ? $this->OriginalObjectID : null;
    }
    /**
     * Set OriginalObjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalObjectID
     * @return \StructType\ShipmentDataOutput
     */
    public function setOriginalObjectID($originalObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($originalObjectID) && !is_string($originalObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalObjectID, true), gettype($originalObjectID)), __LINE__);
        }
        if (is_null($originalObjectID) || (is_array($originalObjectID) && empty($originalObjectID))) {
            unset($this->OriginalObjectID);
        } else {
            $this->OriginalObjectID = $originalObjectID;
        }
        return $this;
    }
}
