<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment2Close StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Shipment2Close
 * @subpackage Structs
 */
class Shipment2Close extends AbstractStructBase
{
    /**
     * The FirstObjectCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstObjectCode;
    /**
     * The LastObjectCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastObjectCode;
    /**
     * The SubProductCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SubProductCode;
    /**
     * Constructor method for Shipment2Close
     * @uses Shipment2Close::setFirstObjectCode()
     * @uses Shipment2Close::setLastObjectCode()
     * @uses Shipment2Close::setSubProductCode()
     * @param string $firstObjectCode
     * @param string $lastObjectCode
     * @param string $subProductCode
     */
    public function __construct($firstObjectCode = null, $lastObjectCode = null, $subProductCode = null)
    {
        $this
            ->setFirstObjectCode($firstObjectCode)
            ->setLastObjectCode($lastObjectCode)
            ->setSubProductCode($subProductCode);
    }
    /**
     * Get FirstObjectCode value
     * @return string|null
     */
    public function getFirstObjectCode()
    {
        return $this->FirstObjectCode;
    }
    /**
     * Set FirstObjectCode value
     * @param string $firstObjectCode
     * @return \StructType\Shipment2Close
     */
    public function setFirstObjectCode($firstObjectCode = null)
    {
        // validation for constraint: string
        if (!is_null($firstObjectCode) && !is_string($firstObjectCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstObjectCode, true), gettype($firstObjectCode)), __LINE__);
        }
        $this->FirstObjectCode = $firstObjectCode;
        return $this;
    }
    /**
     * Get LastObjectCode value
     * @return string|null
     */
    public function getLastObjectCode()
    {
        return $this->LastObjectCode;
    }
    /**
     * Set LastObjectCode value
     * @param string $lastObjectCode
     * @return \StructType\Shipment2Close
     */
    public function setLastObjectCode($lastObjectCode = null)
    {
        // validation for constraint: string
        if (!is_null($lastObjectCode) && !is_string($lastObjectCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastObjectCode, true), gettype($lastObjectCode)), __LINE__);
        }
        $this->LastObjectCode = $lastObjectCode;
        return $this;
    }
    /**
     * Get SubProductCode value
     * @return string|null
     */
    public function getSubProductCode()
    {
        return $this->SubProductCode;
    }
    /**
     * Set SubProductCode value
     * @param string $subProductCode
     * @return \StructType\Shipment2Close
     */
    public function setSubProductCode($subProductCode = null)
    {
        // validation for constraint: string
        if (!is_null($subProductCode) && !is_string($subProductCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subProductCode, true), gettype($subProductCode)), __LINE__);
        }
        $this->SubProductCode = $subProductCode;
        return $this;
    }
}
