<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PIPAuthorizationData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PIPAuthorizationData
 * @subpackage Structs
 */
class PIPAuthorizationData extends AbstractStructBase
{
    /**
     * The PIPType
     * @var string
     */
    public $PIPType;
    /**
     * Constructor method for PIPAuthorizationData
     * @uses PIPAuthorizationData::setPIPType()
     * @param string $pIPType
     */
    public function __construct($pIPType = null)
    {
        $this
            ->setPIPType($pIPType);
    }
    /**
     * Get PIPType value
     * @return string|null
     */
    public function getPIPType()
    {
        return $this->PIPType;
    }
    /**
     * Set PIPType value
     * @uses \EnumType\PIPTypeValues::valueIsValid()
     * @uses \EnumType\PIPTypeValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pIPType
     * @return \StructType\PIPAuthorizationData
     */
    public function setPIPType($pIPType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PIPTypeValues::valueIsValid($pIPType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PIPTypeValues', is_array($pIPType) ? implode(', ', $pIPType) : var_export($pIPType, true), implode(', ', \EnumType\PIPTypeValues::getValidValues())), __LINE__);
        }
        $this->PIPType = $pIPType;
        return $this;
    }
}
