<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShipmentCTT ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfShipmentCTT
 * @subpackage Arrays
 */
class ArrayOfShipmentCTT extends AbstractStructArrayBase
{
    /**
     * The ShipmentCTT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShipmentCTT[]
     */
    public $ShipmentCTT;
    /**
     * Constructor method for ArrayOfShipmentCTT
     * @uses ArrayOfShipmentCTT::setShipmentCTT()
     * @param \StructType\ShipmentCTT[] $shipmentCTT
     */
    public function __construct(array $shipmentCTT = array())
    {
        $this
            ->setShipmentCTT($shipmentCTT);
    }
    /**
     * Get ShipmentCTT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShipmentCTT[]|null
     */
    public function getShipmentCTT()
    {
        return isset($this->ShipmentCTT) ? $this->ShipmentCTT : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentCTT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentCTT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentCTTForArrayConstraintsFromSetShipmentCTT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfShipmentCTTShipmentCTTItem) {
            // validation for constraint: itemType
            if (!$arrayOfShipmentCTTShipmentCTTItem instanceof \StructType\ShipmentCTT) {
                $invalidValues[] = is_object($arrayOfShipmentCTTShipmentCTTItem) ? get_class($arrayOfShipmentCTTShipmentCTTItem) : sprintf('%s(%s)', gettype($arrayOfShipmentCTTShipmentCTTItem), var_export($arrayOfShipmentCTTShipmentCTTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentCTT property can only contain items of type \StructType\ShipmentCTT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentCTT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentCTT[] $shipmentCTT
     * @return \ArrayType\ArrayOfShipmentCTT
     */
    public function setShipmentCTT(array $shipmentCTT = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentCTTArrayErrorMessage = self::validateShipmentCTTForArrayConstraintsFromSetShipmentCTT($shipmentCTT))) {
            throw new \InvalidArgumentException($shipmentCTTArrayErrorMessage, __LINE__);
        }
        if (is_null($shipmentCTT) || (is_array($shipmentCTT) && empty($shipmentCTT))) {
            unset($this->ShipmentCTT);
        } else {
            $this->ShipmentCTT = $shipmentCTT;
        }
        return $this;
    }
    /**
     * Add item to ShipmentCTT value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentCTT $item
     * @return \ArrayType\ArrayOfShipmentCTT
     */
    public function addToShipmentCTT(\StructType\ShipmentCTT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentCTT) {
            throw new \InvalidArgumentException(sprintf('The ShipmentCTT property can only contain items of type \StructType\ShipmentCTT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentCTT[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShipmentCTT|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShipmentCTT|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShipmentCTT|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShipmentCTT|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShipmentCTT|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShipmentCTT
     */
    public function getAttributeName()
    {
        return 'ShipmentCTT';
    }
}
