<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLabelData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLabelData
 * @subpackage Arrays
 */
class ArrayOfLabelData extends AbstractStructArrayBase
{
    /**
     * The LabelData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LabelData[]
     */
    public $LabelData;
    /**
     * Constructor method for ArrayOfLabelData
     * @uses ArrayOfLabelData::setLabelData()
     * @param \StructType\LabelData[] $labelData
     */
    public function __construct(array $labelData = array())
    {
        $this
            ->setLabelData($labelData);
    }
    /**
     * Get LabelData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LabelData[]|null
     */
    public function getLabelData()
    {
        return isset($this->LabelData) ? $this->LabelData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLabelData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelDataForArrayConstraintsFromSetLabelData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLabelDataLabelDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfLabelDataLabelDataItem instanceof \StructType\LabelData) {
                $invalidValues[] = is_object($arrayOfLabelDataLabelDataItem) ? get_class($arrayOfLabelDataLabelDataItem) : sprintf('%s(%s)', gettype($arrayOfLabelDataLabelDataItem), var_export($arrayOfLabelDataLabelDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LabelData property can only contain items of type \StructType\LabelData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LabelData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LabelData[] $labelData
     * @return \ArrayType\ArrayOfLabelData
     */
    public function setLabelData(array $labelData = array())
    {
        // validation for constraint: array
        if ('' !== ($labelDataArrayErrorMessage = self::validateLabelDataForArrayConstraintsFromSetLabelData($labelData))) {
            throw new \InvalidArgumentException($labelDataArrayErrorMessage, __LINE__);
        }
        if (is_null($labelData) || (is_array($labelData) && empty($labelData))) {
            unset($this->LabelData);
        } else {
            $this->LabelData = $labelData;
        }
        return $this;
    }
    /**
     * Add item to LabelData value
     * @throws \InvalidArgumentException
     * @param \StructType\LabelData $item
     * @return \ArrayType\ArrayOfLabelData
     */
    public function addToLabelData(\StructType\LabelData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LabelData) {
            throw new \InvalidArgumentException(sprintf('The LabelData property can only contain items of type \StructType\LabelData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LabelData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LabelData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LabelData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LabelData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LabelData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LabelData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LabelData
     */
    public function getAttributeName()
    {
        return 'LabelData';
    }
}
