<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for themeClil StructType
 * @subpackage Structs
 */
class ThemeClil extends AbstractStructBase
{
    /**
     * The themeClilCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{4}
     * @var string
     */
    public $themeClilCode;
    /**
     * The includeParentNotices
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $includeParentNotices;
    /**
     * Constructor method for themeClil
     * @uses ThemeClil::setThemeClilCode()
     * @uses ThemeClil::setIncludeParentNotices()
     * @param string $themeClilCode
     * @param bool $includeParentNotices
     */
    public function __construct($themeClilCode = null, $includeParentNotices = false)
    {
        $this
            ->setThemeClilCode($themeClilCode)
            ->setIncludeParentNotices($includeParentNotices);
    }
    /**
     * Get themeClilCode value
     * @return string|null
     */
    public function getThemeClilCode()
    {
        return $this->themeClilCode;
    }
    /**
     * Set themeClilCode value
     * @param string $themeClilCode
     * @return \StructType\ThemeClil
     */
    public function setThemeClilCode($themeClilCode = null)
    {
        // validation for constraint: string
        if (!is_null($themeClilCode) && !is_string($themeClilCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($themeClilCode, true), gettype($themeClilCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4})
        if (!is_null($themeClilCode) && !preg_match('/[0-9]{4}/', $themeClilCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}', var_export($themeClilCode, true)), __LINE__);
        }
        $this->themeClilCode = $themeClilCode;
        return $this;
    }
    /**
     * Get includeParentNotices value
     * @return bool|null
     */
    public function getIncludeParentNotices()
    {
        return $this->includeParentNotices;
    }
    /**
     * Set includeParentNotices value
     * @param bool $includeParentNotices
     * @return \StructType\ThemeClil
     */
    public function setIncludeParentNotices($includeParentNotices = false)
    {
        // validation for constraint: boolean
        if (!is_null($includeParentNotices) && !is_bool($includeParentNotices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeParentNotices, true), gettype($includeParentNotices)), __LINE__);
        }
        $this->includeParentNotices = $includeParentNotices;
        return $this;
    }
}
