<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for article StructType
 * @subpackage Structs
 */
class Article extends AbstractStructBase
{
    /**
     * The GTIN13
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9]{13}
     * - ref: hns:GTIN13
     * @var string
     */
    public $GTIN13;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The imprintName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imprintName;
    /**
     * Constructor method for article
     * @uses Article::setGTIN13()
     * @uses Article::setTitle()
     * @uses Article::setImprintName()
     * @param string $gTIN13
     * @param string $title
     * @param string $imprintName
     */
    public function __construct($gTIN13 = null, $title = null, $imprintName = null)
    {
        $this
            ->setGTIN13($gTIN13)
            ->setTitle($title)
            ->setImprintName($imprintName);
    }
    /**
     * Get GTIN13 value
     * @return string|null
     */
    public function getGTIN13()
    {
        return $this->GTIN13;
    }
    /**
     * Set GTIN13 value
     * @param string $gTIN13
     * @return \StructType\Article
     */
    public function setGTIN13($gTIN13 = null)
    {
        // validation for constraint: string
        if (!is_null($gTIN13) && !is_string($gTIN13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gTIN13, true), gettype($gTIN13)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{13})
        if (!is_null($gTIN13) && !preg_match('/[0-9]{13}/', $gTIN13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{13}', var_export($gTIN13, true)), __LINE__);
        }
        $this->GTIN13 = $gTIN13;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Article
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get imprintName value
     * @return string|null
     */
    public function getImprintName()
    {
        return $this->imprintName;
    }
    /**
     * Set imprintName value
     * @param string $imprintName
     * @return \StructType\Article
     */
    public function setImprintName($imprintName = null)
    {
        // validation for constraint: string
        if (!is_null($imprintName) && !is_string($imprintName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imprintName, true), gettype($imprintName)), __LINE__);
        }
        $this->imprintName = $imprintName;
        return $this;
    }
}
