<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebSearchResponse StructType
 * @subpackage Structs
 */
class WebSearchResponse extends AbstractStructBase
{
    /**
     * The requestId
     * Meta information extracted from the WSDL
     * - ref: hns:requestId
     * @var string
     */
    public $requestId;
    /**
     * The searchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:searchType
     * @var string
     */
    public $searchType;
    /**
     * The noticeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:noticeType
     * @var string
     */
    public $noticeType;
    /**
     * The catalog
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * - ref: hns:catalog
     * @var string[]
     */
    public $catalog;
    /**
     * The totalCatalogArticles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:totalCatalogArticles
     * @var int
     */
    public $totalCatalogArticles;
    /**
     * The selection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:selection
     * @var string
     */
    public $selection;
    /**
     * The totalSelectionArticles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:totalSelectionArticles
     * @var int
     */
    public $totalSelectionArticles;
    /**
     * The categoryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:categoryList
     * @var \StructType\CategoryList
     */
    public $categoryList;
    /**
     * The paginationRs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:paginationRs
     * @var \StructType\PaginationRs
     */
    public $paginationRs;
    /**
     * The returnStatus
     * Meta information extracted from the WSDL
     * - ref: hns:returnStatus
     * @var string
     */
    public $returnStatus;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: hns:returnMessage
     * @var string[]
     */
    public $returnMessage;
    /**
     * The Notices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:Notices
     * @var \StructType\Notices
     */
    public $Notices;
    /**
     * Constructor method for WebSearchResponse
     * @uses WebSearchResponse::setRequestId()
     * @uses WebSearchResponse::setSearchType()
     * @uses WebSearchResponse::setNoticeType()
     * @uses WebSearchResponse::setCatalog()
     * @uses WebSearchResponse::setTotalCatalogArticles()
     * @uses WebSearchResponse::setSelection()
     * @uses WebSearchResponse::setTotalSelectionArticles()
     * @uses WebSearchResponse::setCategoryList()
     * @uses WebSearchResponse::setPaginationRs()
     * @uses WebSearchResponse::setReturnStatus()
     * @uses WebSearchResponse::setReturnMessage()
     * @uses WebSearchResponse::setNotices()
     * @param string $requestId
     * @param string $searchType
     * @param string $noticeType
     * @param string[] $catalog
     * @param int $totalCatalogArticles
     * @param string $selection
     * @param int $totalSelectionArticles
     * @param \StructType\CategoryList $categoryList
     * @param \StructType\PaginationRs $paginationRs
     * @param string $returnStatus
     * @param string[] $returnMessage
     * @param \StructType\Notices $notices
     */
    public function __construct($requestId = null, $searchType = null, $noticeType = null, array $catalog = array(), $totalCatalogArticles = null, $selection = null, $totalSelectionArticles = null, \StructType\CategoryList $categoryList = null, \StructType\PaginationRs $paginationRs = null, $returnStatus = null, array $returnMessage = array(), \StructType\Notices $notices = null)
    {
        $this
            ->setRequestId($requestId)
            ->setSearchType($searchType)
            ->setNoticeType($noticeType)
            ->setCatalog($catalog)
            ->setTotalCatalogArticles($totalCatalogArticles)
            ->setSelection($selection)
            ->setTotalSelectionArticles($totalSelectionArticles)
            ->setCategoryList($categoryList)
            ->setPaginationRs($paginationRs)
            ->setReturnStatus($returnStatus)
            ->setReturnMessage($returnMessage)
            ->setNotices($notices);
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\WebSearchResponse
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get searchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->searchType;
    }
    /**
     * Set searchType value
     * @uses \EnumType\SearchType::valueIsValid()
     * @uses \EnumType\SearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\WebSearchResponse
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchType::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchType', is_array($searchType) ? implode(', ', $searchType) : var_export($searchType, true), implode(', ', \EnumType\SearchType::getValidValues())), __LINE__);
        }
        $this->searchType = $searchType;
        return $this;
    }
    /**
     * Get noticeType value
     * @return string|null
     */
    public function getNoticeType()
    {
        return $this->noticeType;
    }
    /**
     * Set noticeType value
     * @uses \EnumType\NoticeType::valueIsValid()
     * @uses \EnumType\NoticeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $noticeType
     * @return \StructType\WebSearchResponse
     */
    public function setNoticeType($noticeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NoticeType::valueIsValid($noticeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NoticeType', is_array($noticeType) ? implode(', ', $noticeType) : var_export($noticeType, true), implode(', ', \EnumType\NoticeType::getValidValues())), __LINE__);
        }
        $this->noticeType = $noticeType;
        return $this;
    }
    /**
     * Get catalog value
     * @return string[]|null
     */
    public function getCatalog()
    {
        return $this->catalog;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalogForArrayConstraintsFromSetCatalog(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $webSearchResponseCatalogItem) {
            // validation for constraint: enumeration
            if (!\EnumType\Catalog::valueIsValid($webSearchResponseCatalogItem)) {
                $invalidValues[] = is_object($webSearchResponseCatalogItem) ? get_class($webSearchResponseCatalogItem) : sprintf('%s(%s)', gettype($webSearchResponseCatalogItem), var_export($webSearchResponseCatalogItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Catalog', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\Catalog::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set catalog value
     * @uses \EnumType\Catalog::valueIsValid()
     * @uses \EnumType\Catalog::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $catalog
     * @return \StructType\WebSearchResponse
     */
    public function setCatalog(array $catalog = array())
    {
        // validation for constraint: array
        if ('' !== ($catalogArrayErrorMessage = self::validateCatalogForArrayConstraintsFromSetCatalog($catalog))) {
            throw new \InvalidArgumentException($catalogArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($catalog) && count($catalog) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($catalog)), __LINE__);
        }
        $this->catalog = $catalog;
        return $this;
    }
    /**
     * Add item to catalog value
     * @uses \EnumType\Catalog::valueIsValid()
     * @uses \EnumType\Catalog::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\WebSearchResponse
     */
    public function addToCatalog($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Catalog::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Catalog', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\Catalog::getValidValues())), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->catalog) && count($this->catalog) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->catalog)), __LINE__);
        }
        $this->catalog[] = $item;
        return $this;
    }
    /**
     * Get totalCatalogArticles value
     * @return int|null
     */
    public function getTotalCatalogArticles()
    {
        return $this->totalCatalogArticles;
    }
    /**
     * Set totalCatalogArticles value
     * @param int $totalCatalogArticles
     * @return \StructType\WebSearchResponse
     */
    public function setTotalCatalogArticles($totalCatalogArticles = null)
    {
        // validation for constraint: int
        if (!is_null($totalCatalogArticles) && !(is_int($totalCatalogArticles) || ctype_digit($totalCatalogArticles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCatalogArticles, true), gettype($totalCatalogArticles)), __LINE__);
        }
        $this->totalCatalogArticles = $totalCatalogArticles;
        return $this;
    }
    /**
     * Get selection value
     * @return string|null
     */
    public function getSelection()
    {
        return $this->selection;
    }
    /**
     * Set selection value
     * @param string $selection
     * @return \StructType\WebSearchResponse
     */
    public function setSelection($selection = null)
    {
        // validation for constraint: string
        if (!is_null($selection) && !is_string($selection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selection, true), gettype($selection)), __LINE__);
        }
        $this->selection = $selection;
        return $this;
    }
    /**
     * Get totalSelectionArticles value
     * @return int|null
     */
    public function getTotalSelectionArticles()
    {
        return $this->totalSelectionArticles;
    }
    /**
     * Set totalSelectionArticles value
     * @param int $totalSelectionArticles
     * @return \StructType\WebSearchResponse
     */
    public function setTotalSelectionArticles($totalSelectionArticles = null)
    {
        // validation for constraint: int
        if (!is_null($totalSelectionArticles) && !(is_int($totalSelectionArticles) || ctype_digit($totalSelectionArticles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalSelectionArticles, true), gettype($totalSelectionArticles)), __LINE__);
        }
        $this->totalSelectionArticles = $totalSelectionArticles;
        return $this;
    }
    /**
     * Get categoryList value
     * @return \StructType\CategoryList|null
     */
    public function getCategoryList()
    {
        return $this->categoryList;
    }
    /**
     * Set categoryList value
     * @param \StructType\CategoryList $categoryList
     * @return \StructType\WebSearchResponse
     */
    public function setCategoryList(\StructType\CategoryList $categoryList = null)
    {
        $this->categoryList = $categoryList;
        return $this;
    }
    /**
     * Get paginationRs value
     * @return \StructType\PaginationRs|null
     */
    public function getPaginationRs()
    {
        return $this->paginationRs;
    }
    /**
     * Set paginationRs value
     * @param \StructType\PaginationRs $paginationRs
     * @return \StructType\WebSearchResponse
     */
    public function setPaginationRs(\StructType\PaginationRs $paginationRs = null)
    {
        $this->paginationRs = $paginationRs;
        return $this;
    }
    /**
     * Get returnStatus value
     * @return string|null
     */
    public function getReturnStatus()
    {
        return $this->returnStatus;
    }
    /**
     * Set returnStatus value
     * @param string $returnStatus
     * @return \StructType\WebSearchResponse
     */
    public function setReturnStatus($returnStatus = null)
    {
        // validation for constraint: string
        if (!is_null($returnStatus) && !is_string($returnStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnStatus, true), gettype($returnStatus)), __LINE__);
        }
        $this->returnStatus = $returnStatus;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string[]|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnMessageForArrayConstraintsFromSetReturnMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $webSearchResponseReturnMessageItem) {
            // validation for constraint: itemType
            if (!is_string($webSearchResponseReturnMessageItem)) {
                $invalidValues[] = is_object($webSearchResponseReturnMessageItem) ? get_class($webSearchResponseReturnMessageItem) : sprintf('%s(%s)', gettype($webSearchResponseReturnMessageItem), var_export($webSearchResponseReturnMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The returnMessage property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set returnMessage value
     * @throws \InvalidArgumentException
     * @param string[] $returnMessage
     * @return \StructType\WebSearchResponse
     */
    public function setReturnMessage(array $returnMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($returnMessageArrayErrorMessage = self::validateReturnMessageForArrayConstraintsFromSetReturnMessage($returnMessage))) {
            throw new \InvalidArgumentException($returnMessageArrayErrorMessage, __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
    /**
     * Add item to returnMessage value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\WebSearchResponse
     */
    public function addToReturnMessage($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The returnMessage property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->returnMessage[] = $item;
        return $this;
    }
    /**
     * Get Notices value
     * @return \StructType\Notices|null
     */
    public function getNotices()
    {
        return $this->Notices;
    }
    /**
     * Set Notices value
     * @param \StructType\Notices $notices
     * @return \StructType\WebSearchResponse
     */
    public function setNotices(\StructType\Notices $notices = null)
    {
        $this->Notices = $notices;
        return $this;
    }
}
