<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for simple StructType
 * @subpackage Structs
 */
class Simple extends AbstractStructBase
{
    /**
     * The article
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:article
     * @var \StructType\Article
     */
    public $article;
    /**
     * The simpleSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:simpleSubject
     * @var \StructType\SimpleSubject
     */
    public $simpleSubject;
    /**
     * The simpleContributor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:simpleContributor
     * @var \StructType\SimpleContributor
     */
    public $simpleContributor;
    /**
     * The productPresentation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:productPresentation
     * @var \StructType\ProductPresentation
     */
    public $productPresentation;
    /**
     * The commercialDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:commercialDescription
     * @var \StructType\CommercialDescription
     */
    public $commercialDescription;
    /**
     * Constructor method for simple
     * @uses Simple::setArticle()
     * @uses Simple::setSimpleSubject()
     * @uses Simple::setSimpleContributor()
     * @uses Simple::setProductPresentation()
     * @uses Simple::setCommercialDescription()
     * @param \StructType\Article $article
     * @param \StructType\SimpleSubject $simpleSubject
     * @param \StructType\SimpleContributor $simpleContributor
     * @param \StructType\ProductPresentation $productPresentation
     * @param \StructType\CommercialDescription $commercialDescription
     */
    public function __construct(\StructType\Article $article = null, \StructType\SimpleSubject $simpleSubject = null, \StructType\SimpleContributor $simpleContributor = null, \StructType\ProductPresentation $productPresentation = null, \StructType\CommercialDescription $commercialDescription = null)
    {
        $this
            ->setArticle($article)
            ->setSimpleSubject($simpleSubject)
            ->setSimpleContributor($simpleContributor)
            ->setProductPresentation($productPresentation)
            ->setCommercialDescription($commercialDescription);
    }
    /**
     * Get article value
     * @return \StructType\Article|null
     */
    public function getArticle()
    {
        return $this->article;
    }
    /**
     * Set article value
     * @param \StructType\Article $article
     * @return \StructType\Simple
     */
    public function setArticle(\StructType\Article $article = null)
    {
        $this->article = $article;
        return $this;
    }
    /**
     * Get simpleSubject value
     * @return \StructType\SimpleSubject|null
     */
    public function getSimpleSubject()
    {
        return $this->simpleSubject;
    }
    /**
     * Set simpleSubject value
     * @param \StructType\SimpleSubject $simpleSubject
     * @return \StructType\Simple
     */
    public function setSimpleSubject(\StructType\SimpleSubject $simpleSubject = null)
    {
        $this->simpleSubject = $simpleSubject;
        return $this;
    }
    /**
     * Get simpleContributor value
     * @return \StructType\SimpleContributor|null
     */
    public function getSimpleContributor()
    {
        return $this->simpleContributor;
    }
    /**
     * Set simpleContributor value
     * @param \StructType\SimpleContributor $simpleContributor
     * @return \StructType\Simple
     */
    public function setSimpleContributor(\StructType\SimpleContributor $simpleContributor = null)
    {
        $this->simpleContributor = $simpleContributor;
        return $this;
    }
    /**
     * Get productPresentation value
     * @return \StructType\ProductPresentation|null
     */
    public function getProductPresentation()
    {
        return $this->productPresentation;
    }
    /**
     * Set productPresentation value
     * @param \StructType\ProductPresentation $productPresentation
     * @return \StructType\Simple
     */
    public function setProductPresentation(\StructType\ProductPresentation $productPresentation = null)
    {
        $this->productPresentation = $productPresentation;
        return $this;
    }
    /**
     * Get commercialDescription value
     * @return \StructType\CommercialDescription|null
     */
    public function getCommercialDescription()
    {
        return $this->commercialDescription;
    }
    /**
     * Set commercialDescription value
     * @param \StructType\CommercialDescription $commercialDescription
     * @return \StructType\Simple
     */
    public function setCommercialDescription(\StructType\CommercialDescription $commercialDescription = null)
    {
        $this->commercialDescription = $commercialDescription;
        return $this;
    }
}
