<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for selection StructType
 * Meta information extracted from the WSDL
 * - type: xs:string
 * @subpackage Structs
 */
class Selection extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The public
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:public
     * @var string
     */
    public $public;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:category
     * @var string
     */
    public $category;
    /**
     * Constructor method for selection
     * @uses Selection::setName()
     * @uses Selection::setPublic()
     * @uses Selection::setCategory()
     * @param string $name
     * @param string $public
     * @param string $category
     */
    public function __construct($name = null, $public = null, $category = null)
    {
        $this
            ->setName($name)
            ->setPublic($public)
            ->setCategory($category);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Selection
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get public value
     * @return string|null
     */
    public function getPublic()
    {
        return $this->public;
    }
    /**
     * Set public value
     * @param string $public
     * @return \StructType\Selection
     */
    public function setPublic($public = null)
    {
        // validation for constraint: string
        if (!is_null($public) && !is_string($public)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($public, true), gettype($public)), __LINE__);
        }
        $this->public = $public;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\Selection
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
}
