<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paginationRs StructType
 * @subpackage Structs
 */
class PaginationRs extends AbstractStructBase
{
    /**
     * The currentPage
     * @var int
     */
    public $currentPage;
    /**
     * The sortBy
     * Meta information extracted from the WSDL
     * - ref: hns:sortBy
     * @var string
     */
    public $sortBy;
    /**
     * The sortOrder
     * Meta information extracted from the WSDL
     * - ref: hns:sortOrder
     * @var string
     */
    public $sortOrder;
    /**
     * The nbResultsPerPage
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 30
     * - minInclusive: 1
     * @var int
     */
    public $nbResultsPerPage;
    /**
     * The nbFoundResults
     * Meta information extracted from the WSDL
     * - ref: hns:nbFoundResults
     * @var int
     */
    public $nbFoundResults;
    /**
     * The nbSentResults
     * Meta information extracted from the WSDL
     * - ref: hns:nbSentResults
     * @var int
     */
    public $nbSentResults;
    /**
     * Constructor method for paginationRs
     * @uses PaginationRs::setCurrentPage()
     * @uses PaginationRs::setSortBy()
     * @uses PaginationRs::setSortOrder()
     * @uses PaginationRs::setNbResultsPerPage()
     * @uses PaginationRs::setNbFoundResults()
     * @uses PaginationRs::setNbSentResults()
     * @param int $currentPage
     * @param string $sortBy
     * @param string $sortOrder
     * @param int $nbResultsPerPage
     * @param int $nbFoundResults
     * @param int $nbSentResults
     */
    public function __construct($currentPage = null, $sortBy = null, $sortOrder = null, $nbResultsPerPage = null, $nbFoundResults = null, $nbSentResults = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setSortBy($sortBy)
            ->setSortOrder($sortOrder)
            ->setNbResultsPerPage($nbResultsPerPage)
            ->setNbFoundResults($nbFoundResults)
            ->setNbSentResults($nbSentResults);
    }
    /**
     * Get currentPage value
     * @return int|null
     */
    public function getCurrentPage()
    {
        return $this->currentPage;
    }
    /**
     * Set currentPage value
     * @param int $currentPage
     * @return \StructType\PaginationRs
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->currentPage = $currentPage;
        return $this;
    }
    /**
     * Get sortBy value
     * @return string|null
     */
    public function getSortBy()
    {
        return $this->sortBy;
    }
    /**
     * Set sortBy value
     * @uses \EnumType\SortBy::valueIsValid()
     * @uses \EnumType\SortBy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortBy
     * @return \StructType\PaginationRs
     */
    public function setSortBy($sortBy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortBy::valueIsValid($sortBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SortBy', is_array($sortBy) ? implode(', ', $sortBy) : var_export($sortBy, true), implode(', ', \EnumType\SortBy::getValidValues())), __LINE__);
        }
        $this->sortBy = $sortBy;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses \EnumType\SortOrder::valueIsValid()
     * @uses \EnumType\SortOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \StructType\PaginationRs
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortOrder::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SortOrder', is_array($sortOrder) ? implode(', ', $sortOrder) : var_export($sortOrder, true), implode(', ', \EnumType\SortOrder::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get nbResultsPerPage value
     * @return int|null
     */
    public function getNbResultsPerPage()
    {
        return $this->nbResultsPerPage;
    }
    /**
     * Set nbResultsPerPage value
     * @param int $nbResultsPerPage
     * @return \StructType\PaginationRs
     */
    public function setNbResultsPerPage($nbResultsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($nbResultsPerPage) && !(is_int($nbResultsPerPage) || ctype_digit($nbResultsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbResultsPerPage, true), gettype($nbResultsPerPage)), __LINE__);
        }
        // validation for constraint: maxInclusive(30)
        if (!is_null($nbResultsPerPage) && $nbResultsPerPage > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 30', var_export($nbResultsPerPage, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($nbResultsPerPage) && $nbResultsPerPage < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($nbResultsPerPage, true)), __LINE__);
        }
        $this->nbResultsPerPage = $nbResultsPerPage;
        return $this;
    }
    /**
     * Get nbFoundResults value
     * @return int|null
     */
    public function getNbFoundResults()
    {
        return $this->nbFoundResults;
    }
    /**
     * Set nbFoundResults value
     * @param int $nbFoundResults
     * @return \StructType\PaginationRs
     */
    public function setNbFoundResults($nbFoundResults = null)
    {
        // validation for constraint: int
        if (!is_null($nbFoundResults) && !(is_int($nbFoundResults) || ctype_digit($nbFoundResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbFoundResults, true), gettype($nbFoundResults)), __LINE__);
        }
        $this->nbFoundResults = $nbFoundResults;
        return $this;
    }
    /**
     * Get nbSentResults value
     * @return int|null
     */
    public function getNbSentResults()
    {
        return $this->nbSentResults;
    }
    /**
     * Set nbSentResults value
     * @param int $nbSentResults
     * @return \StructType\PaginationRs
     */
    public function setNbSentResults($nbSentResults = null)
    {
        // validation for constraint: int
        if (!is_null($nbSentResults) && !(is_int($nbSentResults) || ctype_digit($nbSentResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbSentResults, true), gettype($nbSentResults)), __LINE__);
        }
        $this->nbSentResults = $nbSentResults;
        return $this;
    }
}
